<?php
include 'config.php';
include 'session.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
    $nama_rekening = mysqli_real_escape_string($conn, trim($_POST['nama_rekening']));
    $nama_bank = mysqli_real_escape_string($conn, trim(strtoupper($_POST['nama_bank'])));
    $nomor_rekening = mysqli_real_escape_string($conn, trim($_POST['nomor_rekening']));
    $nama_pemilik = mysqli_real_escape_string($conn, trim(strtoupper($_POST['nama_pemilik'])));
    $aktif = isset($_POST['aktif']) ? 1 : 0;

    // Validasi input
    if (empty($nama_rekening) || empty($nama_bank) || empty($nomor_rekening) || empty($nama_pemilik)) {
        echo "<script>alert('Semua field wajib harus diisi!'); history.back();</script>";
        exit;
    }

    // Validasi nomor rekening (hanya angka)
    if (!preg_match('/^[0-9]+$/', $nomor_rekening)) {
        echo "<script>alert('Nomor rekening hanya boleh berisi angka!'); history.back();</script>";
        exit;
    }

    // Validasi panjang nomor rekening
    if (strlen($nomor_rekening) < 8 || strlen($nomor_rekening) > 20) {
        echo "<script>alert('Nomor rekening harus 8-20 digit!'); history.back();</script>";
        exit;
    }

    // Validasi nama rekening tidak boleh kosong setelah di-trim
    if (strlen(trim($nama_rekening)) < 3) {
        echo "<script>alert('Nama rekening minimal 3 karakter!'); history.back();</script>";
        exit;
    }

    // Validasi nama pemilik tidak boleh kosong
    if (strlen(trim($nama_pemilik)) < 3) {
        echo "<script>alert('Nama pemilik minimal 3 karakter!'); history.back();</script>";
        exit;
    }

    if ($id) {
        // UPDATE - Edit data rekening
        
        // Cek duplikat nomor rekening (kecuali data sendiri)
        $cek_duplikat = mysqli_query($conn, "SELECT id FROM rekening WHERE nomor_rekening = '$nomor_rekening' AND id != '$id'");
        if (mysqli_num_rows($cek_duplikat) > 0) {
            echo "<script>alert('Nomor rekening sudah digunakan oleh rekening lain!'); history.back();</script>";
            exit;
        }

        $query = "UPDATE rekening SET 
                    nama_rekening = '$nama_rekening',
                    nama_bank = '$nama_bank',
                    nomor_rekening = '$nomor_rekening',
                    nama_pemilik = '$nama_pemilik',
                    aktif = '$aktif',
                    updated_at = NOW()
                  WHERE id = '$id'";
        
        $result = mysqli_query($conn, $query);
        
        if ($result) {
            echo "<script>
                alert('Rekening berhasil diupdate!'); 
                window.location='rekening_list.php';
            </script>";
        } else {
            echo "<script>
                alert('Gagal mengupdate rekening: " . mysqli_error($conn) . "'); 
                history.back();
            </script>";
        }
        
    } else {
        // INSERT - Tambah data rekening baru
        
        // Cek duplikat nomor rekening
        $cek_duplikat = mysqli_query($conn, "SELECT id FROM rekening WHERE nomor_rekening = '$nomor_rekening'");
        if (mysqli_num_rows($cek_duplikat) > 0) {
            echo "<script>alert('Nomor rekening sudah terdaftar!'); history.back();</script>";
            exit;
        }

        // Cek duplikat nama rekening (opsional, bisa diaktifkan jika perlu)
        // $cek_nama = mysqli_query($conn, "SELECT id FROM rekening WHERE nama_rekening = '$nama_rekening'");
        // if (mysqli_num_rows($cek_nama) > 0) {
        //     echo "<script>alert('Nama rekening sudah ada!'); history.back();</script>";
        //     exit;
        // }

        $query = "INSERT INTO rekening (nama_rekening, nama_bank, nomor_rekening, nama_pemilik, aktif) 
                  VALUES ('$nama_rekening', '$nama_bank', '$nomor_rekening', '$nama_pemilik', '$aktif')";
        
        $result = mysqli_query($conn, $query);
        
        if ($result) {
            echo "<script>
                alert('Rekening berhasil ditambahkan!'); 
                window.location='rekening_list.php';
            </script>";
        } else {
            echo "<script>
                alert('Gagal menambahkan rekening: " . mysqli_error($conn) . "'); 
                history.back();
            </script>";
        }
    }
    
} else {
    // Jika tidak ada POST data, redirect ke list
    echo "<script>
        alert('Akses tidak valid!'); 
        window.location='rekening_list.php';
    </script>";
    exit;
}
?>