<?php
include 'config.php';
include 'session.php';
include 'navbar.php';

// Handle delete
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    
    // Cek apakah rekening sudah digunakan di transaksi (jika ada tabel penjualan)
    $cek_query = "SELECT table_name FROM information_schema.tables 
                  WHERE table_schema = DATABASE() 
                  AND table_name IN ('penjualan', 'transaksi')";
    $cek_table = mysqli_query($conn, $cek_query);
    
    $sudah_digunakan = false;
    while ($table = mysqli_fetch_assoc($cek_table)) {
        $table_name = $table['table_name'];
        if ($table_name == 'penjualan') {
            $cek = mysqli_query($conn, "SELECT COUNT(*) as jml FROM penjualan WHERE rekening_id = '$id'");
        } else {
            $cek = mysqli_query($conn, "SELECT COUNT(*) as jml FROM transaksi WHERE rekening_id = '$id'");
        }
        
        if ($cek && mysqli_fetch_assoc($cek)['jml'] > 0) {
            $sudah_digunakan = true;
            break;
        }
    }
    
    if ($sudah_digunakan) {
        echo "<script>alert('Rekening tidak bisa dihapus karena sudah digunakan di transaksi!'); window.location='rekening_list.php';</script>";
    } else {
        $query = mysqli_query($conn, "DELETE FROM rekening WHERE id = '$id'");
        if ($query) {
            echo "<script>alert('Rekening berhasil dihapus!'); window.location='rekening_list.php';</script>";
        } else {
            echo "<script>alert('Gagal menghapus rekening!'); window.location='rekening_list.php';</script>";
        }
    }
    exit;
}

// Handle toggle aktif/nonaktif
if (isset($_GET['toggle'])) {
    $id = (int)$_GET['toggle'];
    $query = mysqli_query($conn, "UPDATE rekening SET aktif = IF(aktif=1, 0, 1) WHERE id = '$id'");
    if ($query) {
        echo "<script>window.location='rekening_list.php';</script>";
    }
    exit;
}

// Ambil data rekening
$rekening_list = array();
$query = mysqli_query($conn, "
    SELECT r.*,
           0 as used_count
    FROM rekening r 
    ORDER BY r.nama_rekening
");

if ($query) {
    while ($row = mysqli_fetch_assoc($query)) {
        // Hitung penggunaan jika tabel ada
        $used_count = 0;
        $cek_query = "SELECT table_name FROM information_schema.tables 
                      WHERE table_schema = DATABASE() 
                      AND table_name IN ('penjualan', 'transaksi')";
        $cek_table = mysqli_query($conn, $cek_query);
        
        while ($table = mysqli_fetch_assoc($cek_table)) {
            $table_name = $table['table_name'];
            if ($table_name == 'penjualan') {
                $cek = mysqli_query($conn, "SELECT COUNT(*) as jml FROM penjualan WHERE rekening_id = '" . $row['id'] . "'");
            } else {
                $cek = mysqli_query($conn, "SELECT COUNT(*) as jml FROM transaksi WHERE rekening_id = '" . $row['id'] . "'");
            }
            
            if ($cek) {
                $used_count += mysqli_fetch_assoc($cek)['jml'];
            }
        }
        
        $row['used_count'] = $used_count;
        $rekening_list[] = $row;
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Master Rekening - SBA System</title>
    
    <style>
        body {
            font-family: 'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f8f9fa;
            color: #333;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        h3 {
            color: #333;
            font-weight: 600;
            margin-bottom: 20px;
        }

        .table {
            background: white;
            border: 1px solid #ddd;
            border-radius: 8px;
            overflow: hidden;
            margin-bottom: 20px;
        }

        .table thead th {
            background: #f8f9fa;
            color: #333;
            border-bottom: 2px solid #dee2e6;
            padding: 15px 12px;
            font-weight: 600;
            font-size: 14px;
        }

        .table tbody td {
            padding: 12px;
            border-bottom: 1px solid #eee;
            vertical-align: middle;
        }

        .table tbody tr:hover {
            background: #f8f9fa;
        }

        .btn {
            border-radius: 6px;
            padding: 8px 16px;
            font-size: 14px;
            font-weight: 500;
            border: none;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
            display: inline-block;
        }

        .btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            text-decoration: none;
        }

        .btn-primary {
            background: #007bff;
            color: white;
        }

        .btn-primary:hover {
            background: #0056b3;
            color: white;
        }

        .btn-warning {
            background: #ffc107;
            color: #333;
        }

        .btn-warning:hover {
            background: #e0a800;
            color: #333;
        }

        .btn-danger {
            background: #dc3545;
            color: white;
        }

        .btn-danger:hover {
            background: #c82333;
            color: white;
        }

        .btn-success {
            background: #28a745;
            color: white;
        }

        .btn-success:hover {
            background: #218838;
            color: white;
        }

        .btn-secondary {
            background: #6c757d;
            color: white;
        }

        .btn-secondary:hover {
            background: #545b62;
            color: white;
        }

        .btn-sm {
            padding: 6px 12px;
            font-size: 12px;
        }

        .badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 11px;
            font-weight: 500;
        }

        .badge.bg-success {
            background: #28a745 !important;
            color: white;
        }

        .badge.bg-secondary {
            background: #6c757d !important;
            color: white;
        }

        .badge.bg-info {
            background: #17a2b8 !important;
            color: white;
        }

        .text-muted {
            color: #6c757d !important;
        }

        .d-flex {
            display: flex;
        }

        .gap-2 {
            gap: 0.5rem;
        }

        .justify-content-between {
            justify-content: space-between;
        }

        .align-items-center {
            align-items: center;
        }

        .mb-3 {
            margin-bottom: 1rem;
        }

        .mt-3 {
            margin-top: 1rem;
        }

        .mt-4 {
            margin-top: 1.5rem;
        }

        .alert {
            padding: 12px 16px;
            margin-bottom: 16px;
            border-radius: 4px;
        }

        .alert-info {
            background-color: #d1ecf1;
            border-color: #bee5eb;
            color: #0c5460;
        }

        .alert ul {
            margin: 0;
            padding-left: 20px;
        }

        .table-responsive {
            overflow-x: auto;
        }

        @media (max-width: 768px) {
            .container {
                padding: 10px;
            }
            
            .table {
                font-size: 12px;
            }
            
            .btn-sm {
                padding: 4px 8px;
                font-size: 11px;
            }
        }
    </style>
</head>
<body>

<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>Master Rekening</h3>
        <a href="rekening_form.php" class="btn btn-primary">+ Tambah Rekening</a>
    </div>

    <div class="table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Nama Rekening</th>
                    <th>Bank</th>
                    <th>No. Rekening</th>
                    <th>Nama Pemilik</th>
                    <th>Status</th>
                    <th>Digunakan</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($rekening_list)): ?>
                    <?php foreach ($rekening_list as $index => $row): ?>
                    <tr>
                        <td><?php echo $index + 1; ?></td>
                        <td>
                            <strong><?php echo htmlspecialchars($row['nama_rekening']); ?></strong>
                        </td>
                        <td>
                            <span class="badge bg-info"><?php echo htmlspecialchars($row['nama_bank']); ?></span>
                        </td>
                        <td>
                            <code style="background: #f8f9fa; padding: 2px 6px; border-radius: 3px; font-family: 'Courier New', monospace;">
                                <?php echo htmlspecialchars($row['nomor_rekening']); ?>
                            </code>
                        </td>
                        <td><?php echo htmlspecialchars($row['nama_pemilik']); ?></td>
                        <td>
                            <?php if ($row['aktif'] == 1): ?>
                                <span class="badge bg-success">Aktif</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Non-Aktif</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($row['used_count'] > 0): ?>
                                <span class="badge bg-success"><?php echo $row['used_count']; ?> transaksi</span>
                            <?php else: ?>
                                <span class="text-muted">Belum digunakan</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="d-flex gap-2">
                                <!-- Edit -->
                                <a href="rekening_form.php?id=<?php echo $row['id']; ?>" 
                                   class="btn btn-warning btn-sm" title="Edit">
                                   Edit
                                </a>
                                
                                <!-- Toggle Aktif/Non-aktif -->
                                <a href="?toggle=<?php echo $row['id']; ?>" 
                                   class="btn btn-<?php echo $row['aktif'] ? 'secondary' : 'success'; ?> btn-sm"
                                   title="<?php echo $row['aktif'] ? 'Non-aktifkan' : 'Aktifkan'; ?>"
                                   onclick="return confirm('<?php echo $row['aktif'] ? 'Non-aktifkan' : 'Aktifkan'; ?> rekening ini?')">
                                    <?php echo $row['aktif'] ? 'Non-aktif' : 'Aktifkan'; ?>
                                </a>
                                
                                <!-- Delete (hanya jika belum digunakan) -->
                                <?php if ($row['used_count'] == 0): ?>
                                <a href="?delete=<?php echo $row['id']; ?>" 
                                   class="btn btn-danger btn-sm" title="Hapus"
                                   onclick="return confirm('Yakin hapus rekening ini?')">
                                    Hapus
                                </a>
                                <?php else: ?>
                                <button class="btn btn-secondary btn-sm" disabled title="Tidak bisa dihapus - sudah digunakan">
                                    Terkunci
                                </button>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">
                            Belum ada data rekening. <a href="rekening_form.php">Tambah rekening pertama</a>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="mt-3">
        <a href="dashboard.php" class="btn btn-secondary">Kembali ke Dashboard</a>
    </div>

    <?php if (!empty($rekening_list)): ?>
    <div class="mt-4">
        <div class="alert alert-info">
            <strong>Informasi Master Rekening:</strong>
            <ul class="mb-0 mt-2">
                <li><strong>Total Rekening:</strong> <?php echo count($rekening_list); ?></li>
                <li><strong>Aktif:</strong> <?php echo count(array_filter($rekening_list, function($r) { return $r['aktif'] == 1; })); ?></li>
                <li><strong>Non-aktif:</strong> <?php echo count(array_filter($rekening_list, function($r) { return $r['aktif'] == 0; })); ?></li>
                <li><strong>Sudah digunakan:</strong> <?php echo count(array_filter($rekening_list, function($r) { return $r['used_count'] > 0; })); ?></li>
            </ul>
        </div>
    </div>
    <?php endif; ?>
</div>

</body>
</html>