<?php
// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'config.php';
include 'session.php';

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die("Error: Method not allowed");
}

// Get form data
$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$no_pembelian = trim($_POST['no_pembelian'] ?? '');
$tanggal = $_POST['tanggal'] ?? '';
$supplier_id = (int)($_POST['supplier_id'] ?? 0);
$keterangan = trim($_POST['keterangan'] ?? '');
$status = $_POST['status'] ?? 'confirmed';

// Get arrays
$produk_ids = $_POST['produk_id'] ?? array();
$qty_belis = $_POST['qty_beli'] ?? array();
$satuans = $_POST['satuan'] ?? array();
$harga_belis = $_POST['harga_beli'] ?? array();

// Basic validation
if (empty($no_pembelian) || empty($tanggal) || empty($supplier_id)) {
    die("Error: Data header tidak lengkap! (no_pembelian: $no_pembelian, tanggal: $tanggal, supplier_id: $supplier_id)");
}

if (empty($produk_ids) || count($produk_ids) == 0) {
    die("Error: Minimal harus ada 1 produk!");
}

// Calculate total
$total_amount = 0;
for ($i = 0; $i < count($produk_ids); $i++) {
    if (!empty($produk_ids[$i]) && !empty($qty_belis[$i]) && !empty($harga_belis[$i])) {
        $total_amount += (float)$qty_belis[$i] * (float)$harga_belis[$i];
    }
}

try {
    // Start transaction
    mysqli_begin_transaction($conn);
    
    if ($id > 0) {
        // UPDATE existing
        $stmt = mysqli_prepare($conn, "
            UPDATE pembelian 
            SET no_pembelian = ?, tanggal = ?, supplier_id = ?, 
                total_amount = ?, keterangan = ?, status = ?
            WHERE id = ?
        ");
        mysqli_stmt_bind_param($stmt, "ssidssi", $no_pembelian, $tanggal, $supplier_id, $total_amount, $keterangan, $status, $id);
        
        if (!mysqli_stmt_execute($stmt)) {
            throw new Exception("Gagal update header: " . mysqli_error($conn));
        }
        
        // Delete old details
        mysqli_query($conn, "DELETE FROM pembelian_detail WHERE pembelian_id = $id");
        $pembelian_id = $id;
        
    } else {
        // INSERT new
        $stmt = mysqli_prepare($conn, "
            INSERT INTO pembelian (no_pembelian, tanggal, supplier_id, total_amount, keterangan, status) 
            VALUES (?, ?, ?, ?, ?, ?)
        ");
        mysqli_stmt_bind_param($stmt, "ssidss", $no_pembelian, $tanggal, $supplier_id, $total_amount, $keterangan, $status);
        
        if (!mysqli_stmt_execute($stmt)) {
            throw new Exception("Gagal insert header: " . mysqli_error($conn));
        }
        
        $pembelian_id = mysqli_insert_id($conn);
    }
    
    // Insert details
    for ($i = 0; $i < count($produk_ids); $i++) {
        if (!empty($produk_ids[$i]) && !empty($qty_belis[$i]) && !empty($harga_belis[$i])) {
            $produk_id = (int)$produk_ids[$i];
            $qty_beli = (float)$qty_belis[$i];
            $qty_tersisa = $qty_beli;
            $harga_beli = (float)$harga_belis[$i];
            $satuan = trim($satuans[$i]);
            
            // Get product name
            $produk_nama = '';
            $q_produk = mysqli_query($conn, "SELECT nama FROM produk_interest WHERE id = $produk_id");
            if ($q_produk && $row_produk = mysqli_fetch_assoc($q_produk)) {
                $produk_nama = $row_produk['nama'];
            }
            
            // Handle file upload nota (improved)
            $nota_filename = '';
            if (isset($_FILES['nota_file']['name'][$i]) && !empty($_FILES['nota_file']['name'][$i])) {
                $upload_result = uploadNotaFile($i, $pembelian_id, $produk_id);
                if ($upload_result['success']) {
                    $nota_filename = $upload_result['filename'];
                }
            }
            
            // Insert detail with nota filename
            $stmt_detail = mysqli_prepare($conn, "
                INSERT INTO pembelian_detail (pembelian_id, produk_id, produk_nama, qty_beli, qty_tersisa, harga_beli, satuan, keterangan) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?)
            ");
            mysqli_stmt_bind_param($stmt_detail, "iisdddss", 
                $pembelian_id, $produk_id, $produk_nama, $qty_beli, $qty_tersisa, $harga_beli, $satuan, $nota_filename);
            
            if (!mysqli_stmt_execute($stmt_detail)) {
                throw new Exception("Gagal insert detail produk: " . mysqli_error($conn));
            }
        }
    }
    
    // Commit transaction
    mysqli_commit($conn);
    
    // Success redirect
    $message = $id ? "Pembelian berhasil diupdate!" : "Pembelian berhasil disimpan!";
    header("Location: pembelian_form.php?id=$pembelian_id&msg=" . urlencode($message));
    exit;
    
} catch (Exception $e) {
    // Rollback on error
    mysqli_rollback($conn);
    die("Error: " . $e->getMessage());
}

function uploadNotaFile($index, $pembelian_id, $produk_id) {
    $upload_dir = 'nota_pembelian/';
    
    // Create directory if not exists
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }
    
    $file = $_FILES['nota_file'];
    
    // Check if file was uploaded
    if ($file['error'][$index] !== UPLOAD_ERR_OK) {
        return array('success' => false, 'message' => 'Upload error: ' . $file['error'][$index]);
    }
    
    // Validate file type
    $allowed_types = array('image/jpeg', 'image/jpg', 'image/png', 'application/pdf');
    $file_type = $file['type'][$index];
    
    if (!in_array($file_type, $allowed_types)) {
        return array('success' => false, 'message' => 'File type not allowed');
    }
    
    // Validate file size (max 5MB)
    if ($file['size'][$index] > 5 * 1024 * 1024) {
        return array('success' => false, 'message' => 'File size too large (max 5MB)');
    }
    
    // Generate unique filename
    $file_info = pathinfo($file['name'][$index]);
    $extension = strtolower($file_info['extension']);
    $new_filename = 'nota_' . $pembelian_id . '_' . $produk_id . '_' . time() . '.' . $extension;
    $upload_path = $upload_dir . $new_filename;
    
    // Move uploaded file
    if (move_uploaded_file($file['tmp_name'][$index], $upload_path)) {
        return array('success' => true, 'filename' => $new_filename);
    } else {
        return array('success' => false, 'message' => 'Failed to move uploaded file');
    }
}
?>