<?php
// navbar.php - Bootstrap Navigation Bar with Mobile Support - MOBILE FIXED VERSION
?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/font-awesome.min.css">

<style>
.navbar-custom {
    background-color: #333 !important;
}
.navbar-custom .navbar-nav .nav-link {
    color: #f2f2f2 !important;
    font-size: 17px;
    transition: all 0.3s ease;
}
.navbar-custom .navbar-nav .nav-link:hover {
    background-color: #dc3545;
    color: white !important;
    border-radius: 4px;
}
.navbar-custom .dropdown-menu {
    background-color: #f9f9f9;
    border: none;
    box-shadow: 0px 8px 16px rgba(0,0,0,0.2);
}
.navbar-custom .dropdown-item:hover {
    background-color: #ddd;
    color: #333;
}
.btn-logout {
    background-color: #04AA6D !important;
    border-color: #04AA6D !important;
}
.btn-logout:hover {
    background-color: #037a52 !important;
    border-color: #037a52 !important;
}

/* Custom navbar toggler */
.navbar-toggler {
    border: 1px solid rgba(255,255,255,0.3);
    padding: 4px 8px;
}

.navbar-toggler-icon {
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%28255, 255, 255, 0.75%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");
}

/* Desktop hover dropdown */
@media (min-width: 992px) {
    .navbar .dropdown:hover .dropdown-menu {
        display: block;
        margin-top: 0;
    }
}

/* Mobile dropdown styling */
@media (max-width: 991.98px) {
    .navbar-nav .dropdown-menu {
        background-color: #444;
        border: none;
        box-shadow: none;
        border-radius: 0;
        margin-left: 20px;
        margin-top: 5px;
    }
    
    .navbar-nav .dropdown-item {
        color: #f2f2f2 !important;
        padding: 8px 20px;
        border-bottom: 1px solid #555;
    }
    
    .navbar-nav .dropdown-item:hover {
        background-color: #dc3545;
        color: white !important;
    }
    
    .navbar-nav .dropdown-divider {
        border-color: #555;
        margin: 5px 0;
    }
    
    .navbar-nav .nav-link {
        padding: 10px 15px;
    }
    
    .btn-logout {
        margin: 10px 15px;
        display: inline-block;
        width: auto;
    }
}

/* New styles for Daily Work menu */
.daily-work-menu {
    border-left: 3px solid #28a745;
}

.daily-work-menu .dropdown-item {
    border-left: 2px solid transparent;
    transition: border-left 0.3s ease;
}

.daily-work-menu .dropdown-item:hover {
    border-left: 2px solid #28a745;
}

/* Services menu styling */
.services-menu {
    border-left: 3px solid #0d6efd;
}

.services-menu .dropdown-item {
    border-left: 2px solid transparent;
    transition: border-left 0.3s ease;
}

.services-menu .dropdown-item:hover {
    border-left: 2px solid #0d6efd;
}

/* Pembelian menu styling */
.pembelian-menu {
    border-left: 3px solid #fd7e14;
}

.pembelian-menu .dropdown-item {
    border-left: 2px solid transparent;
    transition: border-left 0.3s ease;
}

.pembelian-menu .dropdown-item:hover {
    border-left: 2px solid #fd7e14;
}

/* Laporan menu styling */
.laporan-menu {
    border-left: 3px solid #6f42c1;
}

.laporan-menu .dropdown-item {
    border-left: 2px solid transparent;
    transition: border-left 0.3s ease;
}

.laporan-menu .dropdown-item:hover {
    border-left: 2px solid #6f42c1;
}

/* Custom color classes */
.text-purple {
    color: #6f42c1 !important;
}
.text-sba {
    color: #0d6efd !important;
}
.text-andik {
    color: #6f42c1 !important;
}
.text-orange {
    color: #fd7e14 !important;
}
.text-customer {
    color: #20c997 !important;
}
</style>

<nav class="navbar navbar-expand-lg navbar-custom sticky-top">
    <div class="container-fluid">
        <a class="navbar-brand text-light" href="dashboard.php">
            <i class="fa fa-dashboard"></i> Dashboard
        </a>

        <!-- Hamburger Button -->
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <!-- Menu Items -->
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav me-auto">

                <?php if (isset($_SESSION['jabatan']) && $_SESSION['jabatan'] != 'Tertutup') { ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fa fa-database"></i> Master Data
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="master_cust.php"><i class="fa fa-users"></i> Customer</a></li>
                        <li><a class="dropdown-item" href="master_produk.php"><i class="fa fa-box"></i> Produk</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="rekening_list.php"><i class="fa fa-university text-success"></i> Master Rekening</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="input_kapal.php"><i class="fa fa-ship"></i> Info Kapal</a></li>
                        <li><a class="dropdown-item" href="view_kapal.php"><i class="fa fa-eye"></i> View Kapal</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="master_supplier.php"><i class="fa fa-truck"></i> Supplier</a></li>
                        <li><a class="dropdown-item" href="produk_supplier.php"><i class="fa fa-tags"></i> Input Harga</a></li>
                    </ul>
                </li>
                <?php } ?>

                <!-- Pembelian Menu -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fa fa-shopping-cart text-orange"></i> Pembelian
                    </a>
                    <ul class="dropdown-menu pembelian-menu">
                        <li><a class="dropdown-item" href="pembelian_form.php"><i class="fa fa-plus-circle text-success"></i> Input Pembelian</a></li>
                        <li><a class="dropdown-item" href="pembelian_list.php"><i class="fa fa-list text-info"></i> Daftar Pembelian</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="pembelian_list.php?status=draft"><i class="fa fa-file-alt text-warning"></i> Draft Pembelian</a></li>
                        <li><a class="dropdown-item" href="pembelian_list.php?status=confirmed"><i class="fa fa-check-circle text-success"></i> Pembelian Confirmed</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="stock_available.php"><i class="fa fa-boxes text-orange"></i> Stock Available</a></li>
                        <li><a class="dropdown-item" href="laporan_pembelian.php"><i class="fa fa-chart-bar text-primary"></i> Laporan Pembelian</a></li>
                    </ul>
                </li>

                <!-- Daily Work Menu -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fa fa-tasks"></i> Daily Work
                    </a>
                    <ul class="dropdown-menu daily-work-menu">
                        <li><a class="dropdown-item" href="daily_work_list.php"><i class="fa fa-list"></i> Daftar Daily Work</a></li>
                        <li><a class="dropdown-item" href="daily_work_add.php"><i class="fa fa-plus-circle"></i> Tambah Daily Work</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="daily_work_list.php?search=<?php echo date('Y-m'); ?>"><i class="fa fa-calendar-alt"></i> Daily Work Bulan Ini</a></li>
                        <li><a class="dropdown-item" href="daily_work_list.php?month=<?php echo date('n'); ?>&year=<?php echo date('Y'); ?>"><i class="fa fa-chart-line"></i> Progress Bulan Ini</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="daily_work_list.php?search=<?php echo isset($_SESSION['username']) ? $_SESSION['username'] : ''; ?>"><i class="fa fa-user-check"></i> Daily Work Saya</a></li>
                    </ul>
                </li>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fa fa-handshake"></i> Meeting
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="meeting_add.php"><i class="fa fa-plus-circle"></i> Buat Meeting</a></li>
                        <li><a class="dropdown-item" href="meeting_list.php"><i class="fa fa-list"></i> Daftar Meeting</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="meeting_calendar.php"><i class="fa fa-calendar"></i> Kalender Meeting</a></li>
                        <li><a class="dropdown-item" href="meeting_action_items.php"><i class="fa fa-tasks"></i> Action Items</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="meeting_report.php"><i class="fa fa-chart-bar"></i> Laporan Meeting</a></li>
                    </ul>
                </li>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fa fa-cogs"></i> Services
                    </a>
                    <ul class="dropdown-menu services-menu">
                        <li><a class="dropdown-item" href="kas_kecil.php"><i class="fa fa-money-bill text-success"></i> Kas Kecil</a></li>
                        <li><a class="dropdown-item" href="kas_bank.php"><i class="fa fa-university text-sba"></i> Bank SBA</a></li>
                        <li><a class="dropdown-item" href="kas_bank2.php"><i class="fa fa-building text-andik"></i> Bank Andik</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="penjualan_form.php"><i class="fa fa-shopping-cart text-warning"></i> Penjualan</a></li>
                        <li><a class="dropdown-item" href="penjualan_list.php"><i class="fa fa-list text-info"></i> Daftar Penjualan</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="draft_penjualan_list.php"><i class="fa fa-list text-secondary"></i> Daftar Draft</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="broadcast_wa.php"><i class="fa fa-whatsapp text-success"></i> Broadcast WA</a></li>
                    </ul>
                </li>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fa fa-chart-line"></i> Laporan
                    </a>
                    <ul class="dropdown-menu laporan-menu">
                        <li><a class="dropdown-item" href="laporan_penjualan.php"><i class="fa fa-shopping-cart"></i> Laporan Penjualan</a></li>
                        <li><a class="dropdown-item" href="laporan_pembelian.php"><i class="fa fa-truck text-orange"></i> Laporan Pembelian</a></li>
                        <li><a class="dropdown-item" href="laporan_piutang.php"><i class="fa fa-users"></i> Laporan Piutang</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <!-- NEW: Customer Reports Section -->
                        <li><a class="dropdown-item" href="laporan_customer.php"><i class="fa fa-user-friends text-customer"></i> Laporan by Customer</a></li>
                        <li><a class="dropdown-item" href="laporan_produk.php"><i class="fa fa-user-friends text-customer"></i> Laporan by Produk</a></li>
                        <li><a class="dropdown-item" href="laporan_customer_transaksi.php"><i class="fa fa-handshake text-customer"></i> Relasi Customer</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="laporan_kas.php"><i class="fa fa-money-bill"></i> Laporan Kas Kecil</a></li>
                        <li><a class="dropdown-item" href="laporan_kas_bank.php"><i class="fa fa-university text-sba"></i> Laporan Bank SBA</a></li>
                        <li><a class="dropdown-item" href="laporan_kas_bank2.php"><i class="fa fa-building text-andik"></i> Laporan Bank Andik</a></li>
                        <li><a class="dropdown-item" href="laporan_profit.php"><i class="fa fa-chart-pie"></i> Laporan Profit</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="laporan_bulanan.php"><i class="fa fa-calendar-alt"></i> Laporan Bulanan</a></li>
                        <li><a class="dropdown-item" href="laporan_tahunan.php"><i class="fa fa-calendar"></i> Laporan Tahunan</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="daily_work_list.php?month=<?php echo date('n'); ?>&year=<?php echo date('Y'); ?>"><i class="fa fa-tasks text-success"></i> Laporan Daily Work</a></li>
                    </ul>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="dashboard.php"><i class="fa fa-home"></i> Home</a>
                </li>
            </ul>

            <ul class="navbar-nav ms-auto">
                <li class="nav-item">
                    <span class="navbar-text me-3"><i class="fa fa-user"></i> 
                        <?php echo isset($_SESSION['username']) ? $_SESSION['username'] : 'User'; ?>
                    </span>
                </li>
                <li class="nav-item">
                    <a class="btn btn-success btn-logout" href="logout.php"><i class="fa fa-sign-out"></i> Logout</a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
// Robust navbar solution that works across all pages
document.addEventListener('DOMContentLoaded', function() {
    
    // Ensure Bootstrap is loaded
    if (typeof bootstrap === 'undefined') {
        console.warn('Bootstrap JS not loaded properly');
        return;
    }

    // Function to handle dropdown clicks manually if Bootstrap fails
    function initializeDropdowns() {
        const dropdownToggles = document.querySelectorAll('.dropdown-toggle');
        
        dropdownToggles.forEach(function(toggle) {
            // Remove any existing event listeners
            toggle.removeEventListener('click', handleDropdownClick);
            
            // Add event listener with proper handling
            toggle.addEventListener('click', handleDropdownClick);
            
            // Ensure Bootstrap dropdown is initialized
            try {
                if (!bootstrap.Dropdown.getInstance(toggle)) {
                    new bootstrap.Dropdown(toggle);
                }
            } catch (e) {
                console.log('Manual dropdown initialization for:', toggle);
            }
        });
    }

    function handleDropdownClick(e) {
        const toggle = e.currentTarget;
        const dropdownMenu = toggle.nextElementSibling;
        
        if (!dropdownMenu || !dropdownMenu.classList.contains('dropdown-menu')) {
            return;
        }

        // Let Bootstrap handle it first
        setTimeout(function() {
            // If Bootstrap didn't handle it (menu not shown), handle manually
            if (!dropdownMenu.classList.contains('show')) {
                e.preventDefault();
                
                // Close other dropdowns
                document.querySelectorAll('.dropdown-menu.show').forEach(function(menu) {
                    if (menu !== dropdownMenu) {
                        menu.classList.remove('show');
                    }
                });
                
                // Toggle current dropdown
                dropdownMenu.classList.toggle('show');
            }
        }, 10);
    }

    // Close dropdown when clicking items
    function setupDropdownItems() {
        document.querySelectorAll('.dropdown-item').forEach(function(item) {
            item.addEventListener('click', function() {
                // Close all dropdowns
                document.querySelectorAll('.dropdown-menu.show').forEach(function(menu) {
                    menu.classList.remove('show');
                });
                
                // Close main navbar on mobile
                const navbarCollapse = document.getElementById('navbarNav');
                if (navbarCollapse && navbarCollapse.classList.contains('show')) {
                    try {
                        const bsCollapse = bootstrap.Collapse.getInstance(navbarCollapse) || 
                                         new bootstrap.Collapse(navbarCollapse, {toggle: false});
                        bsCollapse.hide();
                    } catch (e) {
                        // Fallback manual close
                        navbarCollapse.classList.remove('show');
                    }
                }
            });
        });
    }

    // Close dropdowns when clicking outside
    document.addEventListener('click', function(e) {
        if (!e.target.closest('.dropdown')) {
            document.querySelectorAll('.dropdown-menu.show').forEach(function(menu) {
                menu.classList.remove('show');
            });
        }
    });

    // Initialize everything
    initializeDropdowns();
    setupDropdownItems();

    // Re-initialize if page content changes (for dynamic content)
    const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            if (mutation.addedNodes.length > 0) {
                initializeDropdowns();
                setupDropdownItems();
            }
        });
    });

    observer.observe(document.body, {
        childList: true,
        subtree: true
    });

    console.log('Robust navbar initialized successfully');
});

// Additional fallback for pages that load Bootstrap late
window.addEventListener('load', function() {
    if (typeof bootstrap !== 'undefined') {
        // Re-initialize dropdowns after full page load
        document.querySelectorAll('.dropdown-toggle').forEach(function(toggle) {
            try {
                if (!bootstrap.Dropdown.getInstance(toggle)) {
                    new bootstrap.Dropdown(toggle);
                }
            } catch (e) {
                console.log('Late Bootstrap initialization');
            }
        });
    }
});
</script>