<?php
include 'config.php';

// Check database connection
if (!isset($conn) || !$conn) {
    die('Error: Database connection tidak tersedia!');
}

echo "<h2>Debug Database Structure</h2>";

// Show all tables
echo "<h3>Available Tables:</h3>";
$tables_query = "SHOW TABLES";
$tables_result = mysqli_query($conn, $tables_query);

if ($tables_result) {
    echo "<ul>";
    while ($table = mysqli_fetch_array($tables_result)) {
        echo "<li>" . $table[0] . "</li>";
    }
    echo "</ul>";
} else {
    echo "Error getting tables: " . mysqli_error($conn);
}

// Check meeting table structure
echo "<h3>Meeting Table Structure:</h3>";
$meeting_structure = mysqli_query($conn, "DESCRIBE meeting");
if ($meeting_structure) {
    echo "<table border='1'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    while ($field = mysqli_fetch_array($meeting_structure)) {
        echo "<tr>";
        foreach ($field as $value) {
            echo "<td>" . htmlspecialchars($value ?? '') . "</td>";
        }
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "Error: " . mysqli_error($conn);
}

// Check sample meeting data
echo "<h3>Sample Meeting Data:</h3>";
$sample_query = "SELECT * FROM meeting LIMIT 1";
$sample_result = mysqli_query($conn, $sample_query);
if ($sample_result && mysqli_num_rows($sample_result) > 0) {
    $sample = mysqli_fetch_assoc($sample_result);
    echo "<pre>";
    print_r($sample);
    echo "</pre>";
} else {
    echo "No meeting data found or error: " . mysqli_error($conn);
}

// Check meeting_agenda table if exists
$agenda_check = mysqli_query($conn, "SHOW TABLES LIKE 'meeting_agenda'");
if (mysqli_num_rows($agenda_check) > 0) {
    echo "<h3>Meeting Agenda Table Structure:</h3>";
    $agenda_structure = mysqli_query($conn, "DESCRIBE meeting_agenda");
    if ($agenda_structure) {
        echo "<table border='1'>";
        echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        while ($field = mysqli_fetch_array($agenda_structure)) {
            echo "<tr>";
            foreach ($field as $value) {
                echo "<td>" . htmlspecialchars($value ?? '') . "</td>";
            }
            echo "</tr>";
        }
        echo "</table>";
    }
} else {
    echo "<p>meeting_agenda table does not exist</p>";
}
?>