<?php
session_start();
include 'config.php';
include 'navbar.php';

// Query untuk mengambil data piutang hanya dari rekening SUMBER BERKAT ANAK
// Kalau grand_total 0, kita hitung dari detail penjualan
$query_piutang = "SELECT 
    p.id,
    p.no_invoice,
    p.tanggal,
    CASE 
        WHEN p.grand_total = 0 OR p.grand_total IS NULL THEN 
            COALESCE((SELECT SUM(pd.total) FROM penjualan_detail pd WHERE pd.penjualan_id = p.id), 0)
        ELSE p.grand_total 
    END as grand_total,
    p.status_bayar,
    p.tanggal_bayar,
    p.keterangan_bayar,
    c.nama as customer_nama,
    c.kode as customer_kode,
    c.kota as customer_kota,
    c.no_hp as customer_hp,
    r.nama_rekening,
    DATEDIFF(CURDATE(), p.tanggal) as umur_piutang
FROM penjualan p 
LEFT JOIN customer c ON p.customer_id = c.id
LEFT JOIN rekening r ON p.rekening_id = r.id
WHERE p.status_bayar = 'belum_bayar' 
    AND (r.nama_rekening = 'SUMBER BERKAT ANAK' OR p.rekening = 'SUMBER BERKAT ANAK')
ORDER BY p.tanggal ASC";

$result_piutang = mysqli_query($conn, $query_piutang);

// Hitung total piutang
$query_total = "SELECT 
    SUM(
        CASE 
            WHEN p.grand_total = 0 OR p.grand_total IS NULL THEN 
                COALESCE((SELECT SUM(pd.total) FROM penjualan_detail pd WHERE pd.penjualan_id = p.id), 0)
            ELSE p.grand_total 
        END
    ) as total_piutang,
    COUNT(*) as jumlah_invoice
FROM penjualan p 
LEFT JOIN rekening r ON p.rekening_id = r.id
WHERE p.status_bayar = 'belum_bayar' 
    AND (r.nama_rekening = 'SUMBER BERKAT ANAK' OR p.rekening = 'SUMBER BERKAT ANAK')";

$result_total = mysqli_query($conn, $query_total);
$data_total = mysqli_fetch_assoc($result_total);

// Hitung aging piutang
$query_aging = "SELECT 
    SUM(CASE WHEN DATEDIFF(CURDATE(), p.tanggal) <= 30 THEN 
        CASE 
            WHEN p.grand_total = 0 OR p.grand_total IS NULL THEN 
                COALESCE((SELECT SUM(pd.total) FROM penjualan_detail pd WHERE pd.penjualan_id = p.id), 0)
            ELSE p.grand_total 
        END ELSE 0 END) as current_30,
    SUM(CASE WHEN DATEDIFF(CURDATE(), p.tanggal) BETWEEN 31 AND 60 THEN 
        CASE 
            WHEN p.grand_total = 0 OR p.grand_total IS NULL THEN 
                COALESCE((SELECT SUM(pd.total) FROM penjualan_detail pd WHERE pd.penjualan_id = p.id), 0)
            ELSE p.grand_total 
        END ELSE 0 END) as days_31_60,
    SUM(CASE WHEN DATEDIFF(CURDATE(), p.tanggal) BETWEEN 61 AND 90 THEN 
        CASE 
            WHEN p.grand_total = 0 OR p.grand_total IS NULL THEN 
                COALESCE((SELECT SUM(pd.total) FROM penjualan_detail pd WHERE pd.penjualan_id = p.id), 0)
            ELSE p.grand_total 
        END ELSE 0 END) as days_61_90,
    SUM(CASE WHEN DATEDIFF(CURDATE(), p.tanggal) > 90 THEN 
        CASE 
            WHEN p.grand_total = 0 OR p.grand_total IS NULL THEN 
                COALESCE((SELECT SUM(pd.total) FROM penjualan_detail pd WHERE pd.penjualan_id = p.id), 0)
            ELSE p.grand_total 
        END ELSE 0 END) as over_90
FROM penjualan p 
LEFT JOIN rekening r ON p.rekening_id = r.id
WHERE p.status_bayar = 'belum_bayar' 
    AND (r.nama_rekening = 'SUMBER BERKAT ANAK' OR p.rekening = 'SUMBER BERKAT ANAK')";

$result_aging = mysqli_query($conn, $query_aging);
$data_aging = mysqli_fetch_assoc($result_aging);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Piutang - SUMBER BERKAT ANAK</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .header-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 2rem 0;
            margin-bottom: 2rem;
        }
        .summary-card {
            border: none;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
            transition: transform 0.3s ease;
        }
        .summary-card:hover {
            transform: translateY(-5px);
        }
        .aging-table {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            color: white;
            border-radius: 10px;
        }
        .table-container {
            background: white;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .overdue {
            background-color: #ffebee !important;
        }
        .due-soon {
            background-color: #fff3e0 !important;
        }
        .print-button {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 25px;
            padding: 10px 25px;
            color: white;
            font-weight: bold;
        }
        @media print {
            .no-print {
                display: none !important;
            }
            .header-section {
                background: #667eea !important;
                -webkit-print-color-adjust: exact;
            }
        }
        .badge-overdue {
            background-color: #dc3545;
        }
        .badge-due-soon {
            background-color: #fd7e14;
        }
        .badge-current {
            background-color: #28a745;
        }
    </style>
</head>
<body>

<div class="container-fluid">
    <!-- Header Section -->
    <div class="header-section text-center">
        <div class="container">
            <h1><i class="fas fa-file-invoice-dollar"></i> LAPORAN PIUTANG</h1>
            <h3>REKENING: SUMBER BERKAT ANAK</h3>
            <p class="mb-0">Per tanggal: <?php echo date('d F Y'); ?></p>
        </div>
    </div>

    <div class="container">
        <!-- Summary Cards -->
        <div class="row mb-4">
            <div class="col-md-3 mb-3">
                <div class="card summary-card bg-primary text-white">
                    <div class="card-body text-center">
                        <h5><i class="fas fa-calculator"></i> Total Piutang</h5>
                        <h3>Rp <?php echo number_format($data_total['total_piutang'] ?? 0, 0, ',', '.'); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card summary-card bg-success text-white">
                    <div class="card-body text-center">
                        <h5><i class="fas fa-file-invoice"></i> Jumlah Invoice</h5>
                        <h3><?php echo $data_total['jumlah_invoice'] ?? 0; ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card summary-card bg-warning text-white">
                    <div class="card-body text-center">
                        <h5><i class="fas fa-clock"></i> Rata-rata Umur</h5>
                        <h3><?php 
                        if($data_total['jumlah_invoice'] > 0) {
                            $avg_query = "SELECT AVG(DATEDIFF(CURDATE(), p.tanggal)) as avg_age
                                         FROM penjualan p 
                                         LEFT JOIN rekening r ON p.rekening_id = r.id
                                         WHERE p.status_bayar = 'belum_bayar' 
                                             AND r.nama_rekening = 'SUMBER BERKAT ANAK'";
                            $avg_result = mysqli_query($conn, $avg_query);
                            $avg_data = mysqli_fetch_assoc($avg_result);
                            echo round($avg_data['avg_age'] ?? 0) . ' hari';
                        } else {
                            echo '0 hari';
                        }
                        ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card summary-card bg-info text-white">
                    <div class="card-body text-center">
                        <h5><i class="fas fa-exclamation-triangle"></i> > 90 Hari</h5>
                        <h3>Rp <?php echo number_format($data_aging['over_90'] ?? 0, 0, ',', '.'); ?></h3>
                    </div>
                </div>
            </div>
        </div>

        <!-- Aging Analysis -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header aging-table">
                        <h5 class="mb-0"><i class="fas fa-chart-pie"></i> Analisis Umur Piutang</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="table-dark">
                                    <tr>
                                        <th>Kategori Umur</th>
                                        <th>Jumlah (Rp)</th>
                                        <th>Persentase</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr class="table-success">
                                        <td><i class="fas fa-check-circle text-success"></i> 0 - 30 hari</td>
                                        <td>Rp <?php echo number_format($data_aging['current_30'] ?? 0, 0, ',', '.'); ?></td>
                                        <td><?php echo $data_total['total_piutang'] > 0 ? round(($data_aging['current_30'] / $data_total['total_piutang']) * 100, 1) : 0; ?>%</td>
                                    </tr>
                                    <tr class="table-warning">
                                        <td><i class="fas fa-clock text-warning"></i> 31 - 60 hari</td>
                                        <td>Rp <?php echo number_format($data_aging['days_31_60'] ?? 0, 0, ',', '.'); ?></td>
                                        <td><?php echo $data_total['total_piutang'] > 0 ? round(($data_aging['days_31_60'] / $data_total['total_piutang']) * 100, 1) : 0; ?>%</td>
                                    </tr>
                                    <tr class="table-info">
                                        <td><i class="fas fa-exclamation-circle text-info"></i> 61 - 90 hari</td>
                                        <td>Rp <?php echo number_format($data_aging['days_61_90'] ?? 0, 0, ',', '.'); ?></td>
                                        <td><?php echo $data_total['total_piutang'] > 0 ? round(($data_aging['days_61_90'] / $data_total['total_piutang']) * 100, 1) : 0; ?>%</td>
                                    </tr>
                                    <tr class="table-danger">
                                        <td><i class="fas fa-exclamation-triangle text-danger"></i> > 90 hari</td>
                                        <td>Rp <?php echo number_format($data_aging['over_90'] ?? 0, 0, ',', '.'); ?></td>
                                        <td><?php echo $data_total['total_piutang'] > 0 ? round(($data_aging['over_90'] / $data_total['total_piutang']) * 100, 1) : 0; ?>%</td>
                                    </tr>
                                </tbody>
                                <tfoot class="table-dark">
                                    <tr>
                                        <th>TOTAL</th>
                                        <th>Rp <?php echo number_format($data_total['total_piutang'] ?? 0, 0, ',', '.'); ?></th>
                                        <th>100%</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Detail Piutang -->
        <div class="row">
            <div class="col-12">
                <div class="table-container">
                    <div class="d-flex justify-content-between align-items-center p-3 border-bottom">
                        <h5 class="mb-0"><i class="fas fa-list"></i> Detail Piutang Outstanding</h5>
                        <button onclick="window.print()" class="btn print-button no-print">
                            <i class="fas fa-print"></i> Cetak Laporan
                        </button>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>No</th>
                                    <th>Invoice</th>
                                    <th>Tanggal</th>
                                    <th>Customer</th>
                                    <th>Kota</th>
                                    <th>Kontak</th>
                                    <th>Jumlah</th>
                                    <th>Umur (Hari)</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (mysqli_num_rows($result_piutang) > 0): ?>
                                    <?php $no = 1; ?>
                                    <?php while ($row = mysqli_fetch_assoc($result_piutang)): ?>
                                        <?php 
                                        $class = '';
                                        $badge_class = 'badge-current';
                                        $status_text = 'Normal';
                                        
                                        if ($row['umur_piutang'] > 90) {
                                            $class = 'overdue';
                                            $badge_class = 'badge-overdue';
                                            $status_text = 'Overdue';
                                        } elseif ($row['umur_piutang'] > 60) {
                                            $class = 'due-soon';
                                            $badge_class = 'badge-due-soon';
                                            $status_text = 'Perlu Perhatian';
                                        }
                                        ?>
                                        <tr class="<?php echo $class; ?>">
                                            <td><?php echo $no++; ?></td>
                                            <td>
                                                <strong><?php echo htmlspecialchars($row['no_invoice']); ?></strong>
                                            </td>
                                            <td><?php echo date('d/m/Y', strtotime($row['tanggal'])); ?></td>
                                            <td>
                                                <strong><?php echo htmlspecialchars($row['customer_nama']); ?></strong><br>
                                                <small class="text-muted"><?php echo htmlspecialchars($row['customer_kode']); ?></small>
                                            </td>
                                            <td><?php echo htmlspecialchars($row['customer_kota']); ?></td>
                                            <td>
                                                <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $row['customer_hp']); ?>" 
                                                   class="btn btn-sm btn-success no-print" target="_blank">
                                                    <i class="fab fa-whatsapp"></i>
                                                </a>
                                                <small class="d-block"><?php echo htmlspecialchars($row['customer_hp']); ?></small>
                                            </td>
                                            <td class="text-end">
                                                <strong>Rp <?php echo number_format($row['grand_total'], 0, ',', '.'); ?></strong>
                                            </td>
                                            <td class="text-center">
                                                <span class="fw-bold"><?php echo $row['umur_piutang']; ?></span>
                                            </td>
                                            <td>
                                                <span class="badge <?php echo $badge_class; ?>">
                                                    <?php echo $status_text; ?>
                                                </span>
                                            </td>
                                        </tr>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="9" class="text-center py-4">
                                            <i class="fas fa-check-circle text-success fa-3x mb-3"></i>
                                            <h5 class="text-success">Tidak ada piutang outstanding!</h5>
                                            <p class="text-muted">Semua invoice sudah lunas.</p>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Print Footer -->
        <div class="row mt-4 d-print-block">
            <div class="col-12 text-center">
                <small class="text-muted">
                    Dicetak pada: <?php echo date('d F Y H:i:s'); ?> | 
                    Sistem: SBA Management
                </small>
            </div>
        </div>

        <br><br>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
// Auto refresh setiap 5 menit
setTimeout(function(){
    location.reload();
}, 300000);

// Highlight overdue items on load
document.addEventListener('DOMContentLoaded', function() {
    const overdueRows = document.querySelectorAll('.overdue');
    if(overdueRows.length > 0) {
        console.log('Found ' + overdueRows.length + ' overdue invoices');
    }
});
</script>

</body>
</html>