<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'config.php';
include 'session.php';

header('Content-Type: application/json');

try {
    // Get customer ID from query string
    $id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
    
    if ($id <= 0) {
        throw new Exception("ID customer tidak valid");
    }
    
    // Check if new columns exist
    $columns_query = "SHOW COLUMNS FROM customer LIKE 'nama_toko'";
    $columns_result = mysqli_query($conn, $columns_query);
    $has_new_columns = mysqli_num_rows($columns_result) > 0;
    
    if ($has_new_columns) {
        // New structure with separate fields
        $query = "SELECT c.*, 
                         GROUP_CONCAT(cp.produk_id) as produk_ids,
                         GROUP_CONCAT(pi.nama SEPARATOR ', ') as produk_names
                  FROM customer c
                  LEFT JOIN customer_produk cp ON cp.customer_id = c.id
                  LEFT JOIN produk_interest pi ON pi.id = cp.produk_id
                  WHERE c.id = ?
                  GROUP BY c.id";
    } else {
        // Old structure - try to parse combined name
        $query = "SELECT c.*, 
                         GROUP_CONCAT(cp.produk_id) as produk_ids,
                         GROUP_CONCAT(pi.nama SEPARATOR ', ') as produk_names
                  FROM customer c
                  LEFT JOIN customer_produk cp ON cp.customer_id = c.id
                  LEFT JOIN produk_interest pi ON pi.id = cp.produk_id
                  WHERE c.id = ?
                  GROUP BY c.id";
    }
    
    $stmt = mysqli_prepare($conn, $query);
    if (!$stmt) {
        throw new Exception("Prepare statement failed: " . mysqli_error($conn));
    }
    
    mysqli_stmt_bind_param($stmt, "i", $id);
    
    if (!mysqli_stmt_execute($stmt)) {
        throw new Exception("Execute failed: " . mysqli_stmt_error($stmt));
    }
    
    $result = mysqli_stmt_get_result($stmt);
    $customer = mysqli_fetch_assoc($result);
    
    if (!$customer) {
        throw new Exception("Customer dengan ID $id tidak ditemukan");
    }
    
    // Process product IDs
    $customer['produk_id_array'] = [];
    if (!empty($customer['produk_ids'])) {
        $customer['produk_id_array'] = explode(',', $customer['produk_ids']);
        $customer['produk_id_array'] = array_map('intval', $customer['produk_id_array']);
    }
    
    // Handle field structure based on database structure
    if ($has_new_columns) {
        // New structure - fields already separated
        $customer['nama'] = $customer['nama'] ?? '';
        $customer['nama_toko'] = $customer['nama_toko'] ?? '';
        $customer['merk_toko'] = $customer['merk_toko'] ?? '';
    } else {
        // Old structure - try to parse combined name
        $nama_parts = explode(' - ', $customer['nama'] ?? '');
        $customer['nama'] = $nama_parts[0] ?? '';
        $customer['nama_toko'] = isset($nama_parts[1]) ? $nama_parts[1] : '';
        $customer['merk_toko'] = isset($nama_parts[2]) ? $nama_parts[2] : '';
    }
    
    // Ensure all fields exist and handle null values
    $customer['kota'] = $customer['kota'] ?? '';
    $customer['no_hp'] = $customer['no_hp'] ?? '';
    $customer['jenis'] = $customer['jenis'] ?? '';
    $customer['notes'] = $customer['notes'] ?? '';
    $customer['aktif'] = (int)($customer['aktif'] ?? 1);
    $customer['produk_names'] = $customer['produk_names'] ?? '';
    
    // Remove unnecessary fields from response
    unset($customer['produk_ids']);
    
    mysqli_stmt_close($stmt);
    
    // Return success response
    echo json_encode($customer);

} catch (Exception $e) {
    // Return error response
    http_response_code(400);
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage()
    ]);
}
?>