<?php
include 'config.php';
include 'session.php';

$id = $_GET['id'] ?? 0;

if (!$id) {
    header("Location: draft_penjualan_list.php?error=ID draft tidak valid");
    exit;
}

// Ambil data draft
$query = "SELECT dp.*, c.nama as customer_nama, c.kota as customer_kota, c.kode as customer_kode, c.no_hp as customer_hp
          FROM draft_penjualan dp
          LEFT JOIN customer c ON dp.customer_id = c.id
          WHERE dp.id = '$id'";
$result = mysqli_query($conn, $query);

if (mysqli_num_rows($result) == 0) {
    header("Location: draft_penjualan_list.php?error=Draft tidak ditemukan");
    exit;
}

$draft = mysqli_fetch_assoc($result);

// Ambil detail
$detail_query = "SELECT dpd.*, pi.nama as produk_nama 
                 FROM draft_penjualan_detail dpd
                 JOIN produk_interest pi ON dpd.produk_id = pi.id
                 WHERE dpd.draft_penjualan_id = '$id'
                 ORDER BY dpd.id";
$detail_result = mysqli_query($conn, $detail_query);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Preview Draft - <?= htmlspecialchars($draft['no_draft']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        @media print {
            .no-print { display: none !important; }
            .container { max-width: 100% !important; }
        }
        .draft-watermark {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 120px;
            color: rgba(255, 0, 0, 0.1);
            z-index: -1;
            font-weight: bold;
        }
        .company-header {
            border-bottom: 3px solid #007bff;
            margin-bottom: 30px;
            padding-bottom: 20px;
        }
        .invoice-details {
            background-color: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 30px;
        }
        .table-items {
            margin-bottom: 30px;
        }
        .table-items th {
            background-color: #007bff;
            color: white;
        }
    </style>
</head>
<body>
    <div class="draft-watermark">DRAFT</div>
    
    <div class="container my-4">
        <!-- Header Actions -->
        <div class="d-flex justify-content-between align-items-center mb-4 no-print">
            <h4 class="text-danger">📝 Preview Draft Penjualan</h4>
            <div>
                <button onclick="window.print()" class="btn btn-primary">🖨️ Print</button>
                <a href="draft_penjualan.php?id=<?= $id ?>" class="btn btn-warning">✏️ Edit</a>
                <a href="draft_penjualan_list.php" class="btn btn-secondary">← Kembali</a>
            </div>
        </div>

        <!-- Company Header -->
        <div class="company-header text-center">
            <h2 class="fw-bold">SUMBER BERKAT ANAK</h2>
            <p class="mb-1">Surabaya</p>
            <p class="mb-1">Telp: 082381757525 | Email: isaac@sumberberkatanak.my.id</p>
            <h4 class="text-danger mt-3">DRAFT PENJUALAN</h4>
        </div>

        <!-- Invoice Details -->
        <div class="row invoice-details">
            <div class="col-md-6">
                <h6 class="fw-bold">Kepada:</h6>
                <p class="mb-1"><strong><?= htmlspecialchars($draft['customer_nama']) ?></strong></p>
                <p class="mb-1">Kode: <?= htmlspecialchars($draft['customer_kode']) ?></p>
                <p class="mb-1">Kota: <?= htmlspecialchars($draft['customer_kota']) ?></p>
                <p class="mb-0">HP: <?= htmlspecialchars($draft['customer_hp']) ?></p>
            </div>
            <div class="col-md-6 text-end">
                <table class="table table-borderless table-sm">
                    <tr>
                        <td><strong>No. Draft:</strong></td>
                        <td><?= htmlspecialchars($draft['no_draft']) ?></td>
                    </tr>
                    <tr>
                        <td><strong>Tanggal:</strong></td>
                        <td><?= date('d/m/Y', strtotime($draft['tanggal'])) ?></td>
                    </tr>

                    <tr>
                        <td><strong>Status:</strong></td>
                        <td><span class="badge bg-warning text-dark">DRAFT</span></td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- Items Table -->
        <div class="table-items">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th width="5%">No</th>
                        <th width="35%">Nama Produk</th>
                        <th width="10%">Qty</th>
                        <th width="10%">Satuan</th>
                        <th width="15%">Harga</th>
                        <th width="15%">Total</th>

                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $no = 1;
                    $subtotal = 0;
                    while ($item = mysqli_fetch_assoc($detail_result)): 
                        $total_item = $item['qty'] * $item['harga'];
                        $subtotal += $total_item;
                    ?>
                    <tr>
                        <td class="text-center"><?= $no++ ?></td>
                        <td><?= htmlspecialchars($item['produk_nama']) ?></td>
                        <td class="text-center"><?= number_format($item['qty'], 0, ',', '.') ?></td>
                        <td class="text-center"><?= htmlspecialchars($item['satuan']) ?></td>
                        <td class="text-end">Rp <?= number_format($item['harga'], 0, ',', '.') ?></td>
                        <td class="text-end">Rp <?= number_format($total_item, 0, ',', '.') ?></td>
                        
                    </tr>
                    <?php endwhile; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="5" class="text-end">Grand Total:</th>
                        <th class="text-end">Rp <?= number_format($draft['grand_total'], 0, ',', '.') ?></th>

                    </tr>
                </tfoot>
            </table>
        </div>



        <!-- Footer Info -->
        <div class="row mt-5">
            <div class="col-md-6">
                <div class="border p-3 rounded">
                    <h6 class="fw-bold text-danger">Informasi Draft:</h6>
                    <p class="mb-1"><strong>Dibuat:</strong> <?= date('d/m/Y H:i', strtotime($draft['created_at'])) ?></p>
                    <?php if ($draft['updated_at']): ?>
                    <p class="mb-1"><strong>Diupdate:</strong> <?= date('d/m/Y H:i', strtotime($draft['updated_at'])) ?></p>
                    <?php endif; ?>
                    <p class="mb-0 text-warning"><small><strong>Catatan:</strong> Ini adalah draft dan belum menjadi penjualan resmi.</small></p>
                </div>
            </div>
            <div class="col-md-6">
                <div class="text-center">
                    <p class="mb-4">Hormat kami,</p>
                    <br><br>
                    <p class="mb-0">_________________________</p>
                    <p class="mb-0"><strong>Admin Penjualan</strong></p>
                </div>
            </div>
        </div>

        <!-- Draft Actions -->
        <div class="text-center mt-4 no-print">
            <div class="alert alert-warning">
                <h6 class="fw-bold">Aksi Draft:</h6>
                <a href="draft_penjualan.php?id=<?= $id ?>" class="btn btn-warning me-2">✏️ Edit Draft</a>
                <?php if ($draft['status'] == 'draft'): ?>
                <button class="btn btn-success me-2" onclick="konversiDraft(<?= $id ?>)">📄 Konversi ke Penjualan</button>
                <?php endif; ?>
                <button class="btn btn-danger" onclick="hapusDraft(<?= $id ?>)">🗑️ Hapus Draft</button>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    function konversiDraft(draftId) {
        if (confirm('Apakah Anda yakin ingin mengkonversi draft ini menjadi penjualan resmi?\n\nSetelah dikonversi, draft tidak dapat diedit lagi.')) {
            window.location.href = 'konversi_draft_ke_penjualan.php?draft_id=' + draftId;
        }
    }

    function hapusDraft(draftId) {
        if (confirm('Apakah Anda yakin ingin menghapus draft ini?\n\nData yang dihapus tidak dapat dikembalikan.')) {
            window.location.href = 'hapus_draft_penjualan.php?id=' + draftId;
        }
    }

    // Auto print jika ada parameter print=1
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get('print') === '1') {
        window.print();
    }
    </script>

</body>
</html>