<?php
include 'config.php';
include 'session.php';
include 'navbar.php';

// Ambil daftar supplier
$supplier_list = [];
$q_supplier = mysqli_query($conn, "SELECT id, nama FROM supplier ORDER BY nama");
while ($row = mysqli_fetch_assoc($q_supplier)) {
    $supplier_list[] = $row;
}

$id = $_GET['id'] ?? 0;
$data = [
    'no_draft' => '',
    'tanggal' => date('Y-m-d'),
    'customer_id' => '',
    'keterangan' => ''
];
$detail = [];

if ($id) {
    // Ambil header
    $q = mysqli_query($conn, "SELECT * FROM draft_penjualan WHERE id = '$id'");
    $data = mysqli_fetch_assoc($q);

    // Ambil detail
    $q_detail = mysqli_query($conn, "
        SELECT d.*, pr.nama 
        FROM draft_penjualan_detail d
        JOIN produk_interest pr ON d.produk_id = pr.id
        WHERE d.draft_penjualan_id = '$id'
    ");
    while ($d = mysqli_fetch_assoc($q_detail)) {
        $detail[] = $d;
    }
}

// Auto-generate no_draft kalau belum ada
if (!$id && empty($data['no_draft'])) {
    // Ambil nomor terakhir dari draft yang ada
    $q = mysqli_query($conn, "SELECT no_draft FROM draft_penjualan WHERE no_draft LIKE 'DRAFT-" . date('Ym') . "-%' ORDER BY id DESC LIMIT 1");
    
    if (mysqli_num_rows($q) > 0) {
        $last_row = mysqli_fetch_assoc($q);
        $last_no = $last_row['no_draft'];
        // Extract nomor urut terakhir (contoh: DRAFT-202508-0002 -> 0002)
        $last_num = (int)substr($last_no, -4);
        $next_num = $last_num + 1;
    } else {
        $next_num = 1;
    }

    $bulan_ini = date('Ym');
    $next = str_pad($next_num, 4, '0', STR_PAD_LEFT);
    $data['no_draft'] = "DRAFT-$bulan_ini-$next";
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title><?= $id ? 'Edit' : 'Input' ?> Draft Penjualan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        .margin-input {
            width: 70px !important;
            font-size: 0.8rem;
            text-align: center;
        }
        .draft-header {
            background: linear-gradient(45deg, #ffc107, #fd7e14);
            color: white;
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
        }
        .copy-notification {
            animation: slideIn 0.3s ease-out;
        }
        @keyframes slideIn {
            from {
                transform: translateX(100%);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
        .btn-group-vertical .btn {
            border-radius: 4px !important;
        }
    </style>
</head>
<body class="bg-light p-4">
<div class="container">
    <div class="draft-header">
        <h3 class="mb-1"><?= $id ? 'Edit' : 'Input' ?> Draft Penjualan</h3>
        <small>📝 Mode Draft - Simulasi & Perhitungan Margin</small>
    </div>

    <form action="draft_penjualan_simpan.php" method="post" id="form-draft-penjualan">
        <input type="hidden" name="id" value="<?= htmlspecialchars($id) ?>">

        <div class="row mb-3">
            <div class="col-md-6">
                <label class="form-label">No. Draft</label>
                <input type="text" name="no_draft" class="form-control" required value="<?= htmlspecialchars($data['no_draft']) ?>" readonly style="background-color: #f8f9fa;">
            </div>
            <div class="col-md-6">
                <label class="form-label">Tanggal</label>
                <input type="date" name="tanggal" class="form-control" required value="<?= $data['tanggal'] ?>">
            </div>
        </div>

        <div class="mb-3">
            <label class="form-label">Customer</label>
            <select name="customer_id" id="customer_id" class="form-select" required>
                <option value="">-- Pilih Customer --</option>
                <?php
                $res = mysqli_query($conn, "SELECT id, nama, kode FROM customer WHERE aktif = 1 ORDER BY nama");
                while ($row = mysqli_fetch_assoc($res)) {
                    $selected = ($data['customer_id'] == $row['id']) ? 'selected' : '';
                    $display = "[{$row['kode']}] {$row['nama']}";
                    echo "<option value='{$row['id']}' $selected>$display</option>";
                }
                ?>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Keterangan (Opsional)</label>
            <input type="text" name="keterangan" class="form-control" placeholder="Catatan draft..." value="<?= htmlspecialchars($data['keterangan'] ?? '') ?>">
        </div>

        <h5 class="mt-4">Detail Produk</h5>
        <div class="table-responsive">
            <table class="table table-bordered" id="produk-table">
                <thead class="table-warning">
                    <tr>
                        <th width="18%">Produk</th>
                        <th width="7%">Qty</th>
                        <th width="7%">Unit</th>
                        <th width="13%">Supplier</th>
                        <th width="11%">Harga Beli</th>
                        <th width="11%">Harga Jual</th>
                        <th width="9%">Margin</th>
                        <th width="9%">Total</th>
                        <th width="15%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if ($detail) {
                        foreach ($detail as $row) {
                            ?>
                            <tr class="produk-row">
                                <td>
                                    <select name="produk_id[]" class="form-select produk-select" required>
                                        <option value="">-- Pilih --</option>
                                        <?php
                                        $produk = mysqli_query($conn, "SELECT id, nama FROM produk_interest ORDER BY nama");
                                        while ($p = mysqli_fetch_assoc($produk)) {
                                            $sel = $row['produk_id'] == $p['id'] ? 'selected' : '';
                                            echo "<option value='{$p['id']}' $sel>{$p['nama']}</option>";
                                        }
                                        ?>
                                    </select>
                                </td>
                                <td><input type="number" name="jumlah[]" class="form-control qty" min="1" step="0.01" value="<?= $row['qty'] ?>" required></td>
                                <td><input type="text" name="unit[]" class="form-control" value="<?= $row['satuan'] ?? '' ?>" required></td>
                                <td>
                                    <select name="supplier[]" class="form-select supplier-select">
                                        <option value="">-- Pilih --</option>
                                        <?php
                                        foreach ($supplier_list as $supplier) {
                                            $sel = $row['supplier'] == $supplier['id'] ? 'selected' : '';
                                            echo "<option value='{$supplier['id']}' $sel>{$supplier['nama']}</option>";
                                        }
                                        ?>
                                    </select>
                                </td>
                                <td><input type="number" name="harga_beli[]" class="form-control harga-beli" step="1" value="<?= $row['harga_beli'] ?? 0 ?>"></td>
                                <td><input type="number" name="harga_jual[]" class="form-control harga-jual" step="1" value="<?= $row['harga'] ?>" required></td>
                                <td class="text-center margin-display">
                                    <input type="number" class="form-control margin-input margin-rp-input" step="1" value="0" placeholder="Rp" style="margin-bottom: 2px;">
                                    <input type="number" class="form-control margin-input margin-persen-input" step="0.1" value="0" placeholder="0%">
                                </td>
                                <td class="text-end total"><?= number_format($row['qty'] * $row['harga'], 0, ',', '.') ?></td>
                                <td>
                                    <div class="btn-group-vertical btn-group-sm">
                                        <button type="button" class="btn btn-info btn-sm mb-1" onclick="copyPenawaran(this)" title="Copy Penawaran ke Clipboard">
                                            📋 Copy
                                        </button>
                                        <button type="button" class="btn btn-danger btn-sm" onclick="hapusRow(this)" title="Hapus">
                                            × Hapus
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php
                        }
                    } else {
                        ?>
                        <tr class="produk-row">
                            <td>
                                <select name="produk_id[]" class="form-select produk-select" required>
                                    <option value="">-- Pilih --</option>
                                    <?php
                                    $produk = mysqli_query($conn, "SELECT id, nama FROM produk_interest ORDER BY nama");
                                    while ($p = mysqli_fetch_assoc($produk)) {
                                        echo "<option value='{$p['id']}'>{$p['nama']}</option>";
                                    }
                                    ?>
                                </select>
                            </td>
                            <td><input type="number" name="jumlah[]" class="form-control qty" min="1" step="0.01" value="1" required></td>
                            <td><input type="text" name="unit[]" class="form-control" placeholder="Unit" required></td>
                            <td>
                                <select name="supplier[]" class="form-select supplier-select">
                                    <option value="">-- Pilih --</option>
                                    <?php
                                    foreach ($supplier_list as $supplier) {
                                        echo "<option value='{$supplier['id']}'>{$supplier['nama']}</option>";
                                    }
                                    ?>
                                </select>
                            </td>
                            <td><input type="number" name="harga_beli[]" class="form-control harga-beli" step="1" value="0"></td>
                            <td><input type="number" name="harga_jual[]" class="form-control harga-jual" step="1" required></td>
                            <td class="text-center margin-display">
                                <input type="number" class="form-control margin-input margin-rp-input" step="1" value="0" placeholder="Rp" style="margin-bottom: 2px;">
                                <input type="number" class="form-control margin-input margin-persen-input" step="0.1" value="0" placeholder="0%">
                            </td>
                            <td class="text-end total">0</td>
                            <td>
                                <div class="btn-group-vertical btn-group-sm">
                                    <button type="button" class="btn btn-info btn-sm mb-1" onclick="copyPenawaran(this)" title="Copy Penawaran ke Clipboard">
                                        📋 Copy
                                    </button>
                                    <button type="button" class="btn btn-danger btn-sm" onclick="hapusRow(this)" title="Hapus">
                                        × Hapus
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>

        <button type="button" class="btn btn-secondary btn-sm mb-3" onclick="tambahProduk()">+ Tambah Produk</button>

        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <h6>💡 Tips Margin:</h6>
                        <ul class="small text-muted mb-0">
                            <li><strong>Margin Rp:</strong> Edit keuntungan dalam rupiah per 1 unit produk</li>
                            <li><strong>Margin %:</strong> Edit persentase keuntungan dari harga beli</li>
                            <li>Hijau: Margin bagus (≥20%), Kuning: Margin cukup (10-19%), Merah: Margin rendah (<10%)</li>
                        </ul>
                    </div>
                    <div class="col-md-4">
                        <table class="table table-sm">
                            <tr>
                                <td><strong>Total Harga Beli:</strong></td>
                                <td class="text-end"><strong>Rp <span id="total-beli">0</span></strong></td>
                            </tr>
                            <tr>
                                <td><strong>Total Harga Jual:</strong></td>
                                <td class="text-end"><strong>Rp <span id="total-jual">0</span></strong></td>
                            </tr>
                            <tr class="table-success">
                                <td><strong>Total Margin:</strong></td>
                                <td class="text-end"><strong>Rp <span id="total-margin">0</span></strong></td>
                            </tr>
                            <tr class="table-info">
                                <td><strong>Margin %:</strong></td>
                                <td class="text-end"><strong><span id="total-margin-persen">0</span>%</strong></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="d-flex gap-2 mt-4">
            <button type="submit" class="btn btn-primary">💾 Simpan Draft</button>
            
            <!-- TOMBOL BARU: Copy WA -->
            <button type="button" class="btn btn-success" onclick="copySemuaKeWA()">📱 Copy WA</button>
            
            <?php if ($id): ?>
                <button type="button" class="btn btn-success" onclick="konversiKePenjualan(<?= $id ?>)">📄 Konversi ke Penjualan</button>
                <a href="draft_penjualan_cetak.php?id=<?= $id ?>" target="_blank" class="btn btn-warning">🧾 Preview Draft</a>
            <?php endif; ?>

            <a href="draft_penjualan_list.php" class="btn btn-secondary">← Lihat Daftar Draft</a>
        </div>
    </form>

    <!-- Alert Messages -->
    <?php if (!empty($_SESSION['success'])): ?>
        <div class="alert alert-success alert-dismissible fade show mt-3" role="alert">
            <?= $_SESSION['success'] ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php unset($_SESSION['success']); ?>
    <?php endif; ?>

    <?php if (!empty($_SESSION['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show mt-3" role="alert">
            <?= $_SESSION['error'] ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php unset($_SESSION['error']); ?>
    <?php endif; ?>
</div>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Select2 -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
<!-- Bootstrap -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
function tambahProduk() {
    const tbody = document.querySelector('#produk-table tbody');
    
    // Ambil options untuk produk dan supplier dari row pertama
    const firstRow = document.querySelector('.produk-row');
    const produkOptions = firstRow.querySelector('.produk-select').innerHTML;
    const supplierOptions = firstRow.querySelector('.supplier-select').innerHTML;
    
    // Buat row baru dengan HTML fresh
    const newRowHTML = `
        <tr class="produk-row">
            <td>
                <select name="produk_id[]" class="form-select produk-select" required>
                    ${produkOptions}
                </select>
            </td>
            <td><input type="number" name="jumlah[]" class="form-control qty" min="1" step="0.01" value="1" required></td>
            <td><input type="text" name="unit[]" class="form-control" placeholder="Unit" required></td>
            <td>
                <select name="supplier[]" class="form-select supplier-select">
                    ${supplierOptions}
                </select>
            </td>
            <td><input type="number" name="harga_beli[]" class="form-control harga-beli" step="1" value="0"></td>
            <td><input type="number" name="harga_jual[]" class="form-control harga-jual" step="1" required></td>
            <td class="text-center margin-display">
                <input type="number" class="form-control margin-input margin-rp-input" step="1" value="0" placeholder="Rp" style="margin-bottom: 2px;">
                <input type="number" class="form-control margin-input margin-persen-input" step="0.1" value="0" placeholder="0%">
            </td>
            <td class="text-end total">0</td>
            <td>
                <div class="btn-group-vertical btn-group-sm">
                    <button type="button" class="btn btn-info btn-sm mb-1" onclick="copyPenawaran(this)" title="Copy Penawaran ke Clipboard">
                        📋 Copy
                    </button>
                    <button type="button" class="btn btn-danger btn-sm" onclick="hapusRow(this)" title="Hapus">
                        × Hapus
                    </button>
                </div>
            </td>
        </tr>
    `;
    
    // Insert HTML baru
    tbody.insertAdjacentHTML('beforeend', newRowHTML);
    
    // Ambil row yang baru saja ditambahkan
    const newRow = tbody.lastElementChild;
    
    // Reset select ke option pertama (-- Pilih --)
    newRow.querySelectorAll('select').forEach(select => {
        select.selectedIndex = 0;
    });
    
    // Initialize Select2 untuk elemen baru
    $(newRow).find('.produk-select').select2({
        placeholder: "Cari produk...",
        allowClear: true,
        width: '100%'
    });
    
    $(newRow).find('.supplier-select').select2({
        placeholder: "Pilih supplier...",
        allowClear: true,
        width: '100%'
    });
    
    hitungTotal();
}

function hapusRow(btn) {
    const row = btn.closest('tr');
    const tbody = row.parentElement;
    if (tbody.querySelectorAll('tr').length > 1) {
        row.remove();
        hitungTotal();
    }
}

// Event listener untuk input changes
document.addEventListener('input', function (e) {
    if (e.target.classList.contains('qty') || 
        e.target.classList.contains('harga-jual') || 
        e.target.classList.contains('harga-beli')) {
        hitungTotal();
    }
    
    // Handle margin percentage input
    if (e.target.classList.contains('margin-persen-input')) {
        const row = e.target.closest('tr');
        const hargaBeli = parseFloat(row.querySelector('.harga-beli').value) || 0;
        const marginPersen = parseFloat(e.target.value) || 0;
        
        if (hargaBeli > 0) {
            // Hitung harga jual berdasarkan margin: harga_jual = harga_beli * (1 + margin/100)
            const hargaJual = hargaBeli * (1 + (marginPersen / 100));
            row.querySelector('.harga-jual').value = Math.round(hargaJual);
            hitungTotal();
        }
    }
    
    // Handle margin Rupiah input - FITUR BARU
    if (e.target.classList.contains('margin-rp-input')) {
        const row = e.target.closest('tr');
        const hargaBeli = parseFloat(row.querySelector('.harga-beli').value) || 0;
        const marginRpPerUnit = parseFloat(e.target.value) || 0;
        
        // Hitung harga jual berdasarkan margin Rp per unit: harga_jual = harga_beli + margin_rp_per_unit
        const hargaJual = hargaBeli + marginRpPerUnit;
        row.querySelector('.harga-jual').value = Math.round(hargaJual);
        hitungTotal();
    }
});

function hitungTotal() {
    let totalJual = 0;
    let totalBeli = 0;
    
    document.querySelectorAll('#produk-table tbody tr').forEach(row => {
        const qty = parseFloat(row.querySelector('.qty').value) || 0;
        const hargaJual = parseFloat(row.querySelector('.harga-jual').value) || 0;
        const hargaBeli = parseFloat(row.querySelector('.harga-beli').value) || 0;
        
        const totalRowJual = qty * hargaJual;
        const totalRowBeli = qty * hargaBeli;
        const marginRpPerUnit = hargaJual - hargaBeli; // Margin per unit
        const marginRpTotal = totalRowJual - totalRowBeli; // Margin total
        const marginPersen = hargaBeli > 0 ? ((hargaJual - hargaBeli) / hargaBeli * 100) : 0;
        
        // Update tampilan di row
        row.querySelector('.total').textContent = totalRowJual.toLocaleString('id-ID');
        
        // Update input margin Rp (per unit) dan % jika tidak sedang di-edit
        const marginRpInput = row.querySelector('.margin-rp-input');
        const marginPersenInput = row.querySelector('.margin-persen-input');
        
        if (document.activeElement !== marginRpInput) {
            marginRpInput.value = Math.round(marginRpPerUnit); // Margin per unit
        }
        if (document.activeElement !== marginPersenInput) {
            marginPersenInput.value = marginPersen.toFixed(1);
        }
        
        // Warna margin berdasarkan persentase
        if (marginPersen >= 20) {
            marginRpInput.className = 'form-control margin-input margin-rp-input text-success';
            marginPersenInput.className = 'form-control margin-input margin-persen-input text-success';
        } else if (marginPersen >= 10) {
            marginRpInput.className = 'form-control margin-input margin-rp-input text-warning';
            marginPersenInput.className = 'form-control margin-input margin-persen-input text-warning';
        } else {
            marginRpInput.className = 'form-control margin-input margin-rp-input text-danger';
            marginPersenInput.className = 'form-control margin-input margin-persen-input text-danger';
        }
        
        totalJual += totalRowJual;
        totalBeli += totalRowBeli;
    });
    
    const totalMargin = totalJual - totalBeli;
    const totalMarginPersen = totalBeli > 0 ? ((totalJual - totalBeli) / totalBeli * 100) : 0;
    
    // Update summary
    document.getElementById('total-jual').textContent = totalJual.toLocaleString('id-ID');
    document.getElementById('total-beli').textContent = totalBeli.toLocaleString('id-ID');
    document.getElementById('total-margin').textContent = totalMargin.toLocaleString('id-ID');
    document.getElementById('total-margin-persen').textContent = totalMarginPersen.toFixed(1);
}

function konversiKePenjualan(draftId) {
    if (confirm('Apakah Anda yakin ingin mengkonversi draft ini menjadi penjualan resmi?')) {
        window.location.href = 'konversi_draft_ke_penjualan.php?draft_id=' + draftId;
    }
}

// Fungsi copy penawaran ke clipboard
function copyPenawaran(button) {
    const row = button.closest('tr');
    
    // Ambil data dari row
    const produkSelect = row.querySelector('.produk-select');
    const produkNama = produkSelect.options[produkSelect.selectedIndex].text;
    const qty = row.querySelector('.qty').value;
    const unit = row.querySelector('input[name="unit[]"]').value;
    const hargaJual = parseFloat(row.querySelector('.harga-jual').value) || 0;
    const total = qty * hargaJual;
    
    // Buat pesan penawaran
    const pesan = `🔥 *PENAWARAN SPESIAL* 🔥

Ini saya kirimkan detail nya :

📦 *${produkNama}*
🔢 Jumlah: ${qty} ${unit}
💰 *Harga: Rp ${hargaJual.toLocaleString('id-ID')} per ${unit}*

🎯 *Total: Rp ${total.toLocaleString('id-ID')}*
`;

    // Copy ke clipboard
    navigator.clipboard.writeText(pesan).then(function() {
        showNotification('✅ Penawaran berhasil dicopy ke clipboard!', 'success');
        
        const originalText = button.innerHTML;
        button.innerHTML = '✅ Copied!';
        button.classList.remove('btn-info');
        button.classList.add('btn-success');
        
        setTimeout(function() {
            button.innerHTML = originalText;
            button.classList.remove('btn-success');
            button.classList.add('btn-info');
        }, 2000);
    }).catch(function(err) {
        console.error('Error copying to clipboard: ', err);
        showNotification('❌ Gagal copy ke clipboard', 'error');
    });
}

// FUNGSI BARU: Copy semua produk ke WhatsApp
function copySemuaKeWA() {
    let pesan = `*DAFTAR HARGA*\n`;
    
    let nomorUrut = 1;
    let adaProduk = false;
    
    // Loop semua row produk
    document.querySelectorAll('#produk-table tbody tr').forEach(row => {
        const produkSelect = row.querySelector('.produk-select');
        const qty = row.querySelector('.qty').value;
        const unit = row.querySelector('input[name="unit[]"]').value;
        const hargaJual = parseFloat(row.querySelector('.harga-jual').value) || 0;
        
        // Pastikan ada produk yang dipilih dan harga terisi
        if (produkSelect.selectedIndex > 0 && hargaJual > 0 && qty > 0 && unit.trim() !== '') {
            const produkNama = produkSelect.options[produkSelect.selectedIndex].text;
            
            pesan += `${nomorUrut}. ${produkNama} - ${qty} ${unit} @ Rp ${hargaJual.toLocaleString('id-ID')}\n`;
            
            nomorUrut++;
            adaProduk = true;
        }
    });
    
    // Validasi apakah ada produk yang valid
    if (!adaProduk) {
        showNotification('❌ Belum ada produk yang lengkap datanya untuk di-copy', 'error');
        return;
    }
    
    // Copy ke clipboard
    navigator.clipboard.writeText(pesan).then(function() {
        showNotification('✅ Daftar produk berhasil dicopy untuk WhatsApp!', 'success');
    }).catch(function(err) {
        console.error('Error copying to clipboard: ', err);
        showNotification('❌ Gagal copy ke clipboard', 'error');
    });
}

// Fungsi untuk menampilkan notifikasi
function showNotification(message, type) {
    // Hapus notifikasi yang ada
    const existingNotif = document.querySelector('.copy-notification');
    if (existingNotif) {
        existingNotif.remove();
    }
    
    // Buat notifikasi baru
    const notification = document.createElement('div');
    notification.className = `alert alert-${type === 'success' ? 'success' : 'danger'} copy-notification`;
    notification.style.position = 'fixed';
    notification.style.top = '20px';
    notification.style.right = '20px';
    notification.style.zIndex = '9999';
    notification.style.minWidth = '300px';
    notification.innerHTML = `
        <div class="d-flex align-items-center">
            <span>${message}</span>
            <button type="button" class="btn-close ms-auto" onclick="this.parentElement.parentElement.remove()"></button>
        </div>
    `;
    
    document.body.appendChild(notification);
    
    // Auto remove setelah 3 detik
    setTimeout(function() {
        if (notification.parentElement) {
            notification.remove();
        }
    }, 3000);
}

// Initialize pada load
$(document).ready(function () {
    // Initialize Select2
    $('#customer_id').select2({
        placeholder: "Pilih customer",
        allowClear: true,
        width: '100%'
    });
    
    $('.produk-select').select2({
        placeholder: "Cari produk...",
        allowClear: true,
        width: '100%'
    });
    
    $('.supplier-select').select2({
        placeholder: "Pilih supplier...",
        allowClear: true,
        width: '100%'
    });
    
    // Hitung total pada load
    hitungTotal();
});

window.addEventListener('DOMContentLoaded', hitungTotal);
</script>

</body>
</html>