<?php
include 'config.php';
include 'session.php';

$selected_month = isset($_GET['month']) ? $_GET['month'] : date('Y-m');
$month_parts = explode('-', $selected_month);
$year = $month_parts[0];
$month = $month_parts[1];

$start_date = $year . '-' . $month . '-01';
$end_date = date('Y-m-t', strtotime($start_date));

$kotaProvinsi = [
    'Surabaya' => 'Jawa Timur', 'Malang' => 'Jawa Timur', 'Sidoarjo' => 'Jawa Timur',
    'Jakarta' => 'DKI Jakarta', 'Bandung' => 'Jawa Barat', 'Medan' => 'Sumatera Utara',
    'Semarang' => 'Jawa Tengah', 'Denpasar' => 'Bali', 'Makassar' => 'Sulawesi Selatan',
    'Yogyakarta' => 'DI Yogyakarta', 'Namlea' => 'Maluku', 'Bau-bau' => 'Sulawesi Tenggara',
    'Bacan' => 'Maluku Utara', 'Agats' => 'Papua Selatan', 'Tidore' => 'Maluku Utara',
    'Tahuna' => 'Sulawesi Utara', 'Kisar' => 'Maluku', 'Nunukan' => 'Kalimantan Utara',
    'Saumlaki' => 'Maluku', 'Bima' => 'Nusa Tenggara Barat', 'Dompu' => 'Nusa Tenggara Barat',
    'Bula' => 'Maluku', 'Fakfak' => 'Papua Barat', 'Sabu' => 'Nusa Tenggara Timur',
    'Timika' => 'Papua Tengah', 'Moa' => 'Maluku', 'Wanci' => 'Sulawesi Tenggara',
    'Banggai' => 'Sulawesi Tengah', 'Maba' => 'Maluku Utara', 'Jailolo' => 'Maluku Utara',
    'Merauke' => 'Papua Selatan', 'Ternate' => 'Maluku Utara'
];

$targetProfit = 100000000;

// Query calculations
$totalPenjualanQuery = "SELECT SUM(pd.qty * pd.harga) AS total FROM penjualan_detail pd INNER JOIN penjualan p ON pd.penjualan_id = p.id WHERE p.tanggal >= '$start_date' AND p.tanggal <= '$end_date'";
$totalPenjualan = $conn->query($totalPenjualanQuery)->fetch_assoc()['total'] ?? 0;

$totalPembelianQuery = "SELECT SUM(pd.qty * COALESCE(pd.harga_beli, 0)) AS total FROM penjualan_detail pd INNER JOIN penjualan p ON pd.penjualan_id = p.id WHERE p.tanggal >= '$start_date' AND p.tanggal <= '$end_date' AND pd.harga_beli IS NOT NULL AND pd.harga_beli > 0";
$totalPembelian = $conn->query($totalPembelianQuery)->fetch_assoc()['total'] ?? 0;

$profit = $totalPenjualan - $totalPembelian;
$profitPercent = $targetProfit > 0 ? round(($profit / $targetProfit) * 100, 1) : 0;
$profitMargin = $totalPenjualan > 0 ? round(($profit / $totalPenjualan) * 100, 1) : 0;

$totalTransaksiQuery = "SELECT COUNT(*) as total FROM penjualan WHERE tanggal >= '$start_date' AND tanggal <= '$end_date'";
$totalTransaksiResult = $conn->query($totalTransaksiQuery);
$totalTransaksi = $totalTransaksiResult ? $totalTransaksiResult->fetch_assoc()['total'] : 0;

// Customer data
$debugQuery = "SHOW TABLES LIKE 'customer'";
$tableExists = $conn->query($debugQuery);

if ($tableExists && $tableExists->num_rows > 0) {
    $fieldsQuery = "SHOW COLUMNS FROM customer LIKE 'aktif'";
    $hasAktifField = $conn->query($fieldsQuery) && $conn->query($fieldsQuery)->num_rows > 0;
    $customerCondition = $hasAktifField ? "WHERE aktif = 1" : "";
    
    $totalCustomerQuery = "SELECT COUNT(*) as total FROM customer $customerCondition";
    $totalCustomerResult = $conn->query($totalCustomerQuery);
    $totalCustomer = $totalCustomerResult ? $totalCustomerResult->fetch_assoc()['total'] : 0;
    
    $perKotaQuery = "SELECT kota, COUNT(*) as total FROM customer $customerCondition GROUP BY kota ORDER BY kota ASC";
    $perKotaRes = $conn->query($perKotaQuery);
    $perKotaGrouped = [];
    if ($perKotaRes) {
        while($row = $perKotaRes->fetch_assoc()) {
            $prov = $kotaProvinsi[$row['kota']] ?? 'Lainnya';
            $perKotaGrouped[$prov][] = $row;
        }
    }
    
    $customerListQuery = "SELECT * FROM customer $customerCondition ORDER BY nama ASC";
    $customerListRes = $conn->query($customerListQuery);
    $customerList = [];
    if ($customerListRes) {
        while ($row = $customerListRes->fetch_assoc()) {
            $provinsi = $kotaProvinsi[$row['kota']] ?? 'Lainnya';
            $row['provinsi'] = $provinsi;
            $customerList[] = $row;
        }
    }
} else {
    $totalCustomer = 0;
    $perKotaGrouped = [];
    $customerList = [];
    $hasAktifField = false;
    $customerCondition = "";
}

// FOLLOW-UP ALERT
$followUpQuery = "
    SELECT 
        c.id, 
        c.nama, 
        c.kota, 
        c.no_hp,
        MAX(p.tanggal) as last_order_date,
        DATEDIFF(CURDATE(), MAX(p.tanggal)) as days_since_last_order,
        COUNT(DISTINCT p.id) as total_orders,
        COALESCE(SUM(pd.qty * pd.harga), 0) as total_revenue
    FROM customer c
    INNER JOIN penjualan p ON c.id = p.customer_id
    LEFT JOIN penjualan_detail pd ON p.id = pd.penjualan_id
    " . ($hasAktifField ? "WHERE c.aktif = 1" : "") . "
    GROUP BY c.id, c.nama, c.kota, c.no_hp
    HAVING days_since_last_order >= 10
    ORDER BY days_since_last_order DESC
";
$followUpResult = $conn->query($followUpQuery);
$followUpCustomers = ['urgent' => [], 'warning' => [], 'watch' => []];

if ($followUpResult) {
    while ($row = $followUpResult->fetch_assoc()) {
        $days = $row['days_since_last_order'];
        if ($days >= 45) {
            $followUpCustomers['urgent'][] = $row;
        } elseif ($days >= 30) {
            $followUpCustomers['warning'][] = $row;
        } else {
            $followUpCustomers['watch'][] = $row;
        }
    }
}

$totalFollowUp = count($followUpCustomers['urgent']) + count($followUpCustomers['warning']) + count($followUpCustomers['watch']);

$topCustomers = [];
if ($totalCustomer > 0) {
    $topCustomersQuery = "SELECT c.nama, SUM(p.grand_total) as total_sales, COUNT(p.id) as total_orders FROM customer c LEFT JOIN penjualan p ON c.id = p.customer_id WHERE p.tanggal >= '$start_date' AND p.tanggal <= '$end_date' GROUP BY c.id HAVING total_sales > 0 ORDER BY total_sales DESC LIMIT 5";
    $topCustomersResult = $conn->query($topCustomersQuery);
    if ($topCustomersResult) {
        $topCustomers = $topCustomersResult->fetch_all(MYSQLI_ASSOC);
    }
}

$itemsMasalahQuery = "SELECT pi.nama as produk_nama, pd.qty, pd.harga as harga_jual, pd.harga_beli, (pd.qty * pd.harga) as total_jual, (pd.qty * pd.harga_beli) as total_beli, ((pd.qty * pd.harga) - (pd.qty * pd.harga_beli)) as profit_item FROM penjualan_detail pd LEFT JOIN produk_interest pi ON pd.produk_id = pi.id INNER JOIN penjualan p ON pd.penjualan_id = p.id WHERE pd.harga_beli > pd.harga AND p.tanggal >= '$start_date' AND p.tanggal <= '$end_date' ORDER BY profit_item ASC LIMIT 10";
$itemsMasalahResult = $conn->query($itemsMasalahQuery);
$itemsMasalah = $itemsMasalahResult ? $itemsMasalahResult->fetch_all(MYSQLI_ASSOC) : [];

$monthNames = ['01' => 'Januari', '02' => 'Februari', '03' => 'Maret', '04' => 'April', '05' => 'Mei', '06' => 'Juni', '07' => 'Juli', '08' => 'Agustus', '09' => 'September', '10' => 'Oktober', '11' => 'November', '12' => 'Desember'];
$currentMonthName = $monthNames[$month] . ' ' . $year;
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Customer - <?= $currentMonthName ?></title>
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body{background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);min-height:100vh;font-family:'Inter',sans-serif}
        .dashboard-container{background:rgba(255,255,255,0.95);backdrop-filter:blur(10px);border-radius:20px;box-shadow:0 20px 40px rgba(0,0,0,0.1);margin:20px;padding:30px}
        .metric-card{background:white;border-radius:15px;box-shadow:0 10px 25px rgba(0,0,0,0.08);transition:all 0.3s ease;border:none;overflow:hidden;position:relative;margin-bottom:20px}
        .metric-card:hover{transform:translateY(-5px);box-shadow:0 20px 40px rgba(0,0,0,0.15)}
        .metric-card::before{content:'';position:absolute;top:0;left:0;right:0;height:4px;background:linear-gradient(90deg,var(--accent-color),var(--accent-light))}
        .metric-card.success::before{--accent-color:#28a745;--accent-light:#34ce57}
        .metric-card.danger::before{--accent-color:#dc3545;--accent-light:#ff4757}
        .metric-card.dark::before{--accent-color:#343a40;--accent-light:#495057}
        .metric-card.primary::before{--accent-color:#007bff;--accent-light:#0056b3}
        .metric-card.warning::before{--accent-color:#ffc107;--accent-light:#ffcd39}
        .metric-icon{font-size:2.5rem;margin-bottom:20px;opacity:0.8}
        .metric-value{font-size:1.5rem;font-weight:700;margin-bottom:8px;line-height:1.2}
        .metric-label{font-size:0.9rem;color:#6c757d;font-weight:500;margin-bottom:15px}
        .progress-modern{height:8px;border-radius:4px;background:rgba(0,0,0,0.1);overflow:hidden}
        .progress-modern .progress-bar{background:linear-gradient(90deg,var(--accent-color),var(--accent-light));border-radius:4px}
        .province-card{background:linear-gradient(135deg,#f8f9fa,#e9ecef);border-radius:12px;border-left:4px solid #007bff;margin-bottom:25px;padding:20px}
        .city-card{background:white;border-radius:10px;transition:all 0.2s ease;border:1px solid #e9ecef;padding:15px;margin-bottom:10px}
        .city-card:hover{box-shadow:0 5px 15px rgba(0,0,0,0.1);transform:translateY(-2px)}
        .header-card{background:linear-gradient(135deg,#667eea,#764ba2);color:white;border-radius:15px;padding:30px;margin-bottom:30px}
        .date-time-card{background:rgba(255,255,255,0.15);backdrop-filter:blur(10px);border-radius:12px;padding:15px 20px;border:1px solid rgba(255,255,255,0.2)}
        .stats-card{background:white;border-radius:15px;box-shadow:0 10px 25px rgba(0,0,0,0.08);border:none}
        .table-modern{border-radius:10px;overflow:hidden}
        .table-modern thead th{background:linear-gradient(135deg,#343a40,#495057);color:white;border:none;font-weight:600;padding:15px}
        .table-modern tbody tr:hover{background:rgba(0,123,255,0.05)}
        .badge-modern{padding:8px 12px;border-radius:20px;font-weight:500}
        .margin-indicator{display:inline-block;padding:4px 8px;border-radius:12px;font-size:0.8rem;font-weight:600;margin-left:8px}
        .margin-good{background:#d4edda;color:#155724}
        .margin-average{background:#fff3cd;color:#856404}
        .margin-poor{background:#f8d7da;color:#721c24}
        .month-selector{background:white;border-radius:15px;padding:20px;margin-bottom:20px;box-shadow:0 5px 15px rgba(0,0,0,0.1)}
        @keyframes fadeInUp{from{opacity:0;transform:translateY(30px)}to{opacity:1;transform:translateY(0)}}
        .animate-card{animation:fadeInUp 0.6s ease forwards}
        .insights-card{background:linear-gradient(135deg,#ff9a9e 0%,#fecfef 50%,#fecfef 100%);border-radius:15px;color:white;padding:25px;margin-bottom:20px}
        .table-modern tbody td{padding:15px;vertical-align:middle}
        .dashboard-spacing{margin-bottom:30px}
        .alert-follow-up-card{background:white;border-radius:15px;box-shadow:0 10px 25px rgba(0,0,0,0.08);overflow:hidden}
        .alert-follow-up-card .card-header{background:linear-gradient(135deg,#667eea,#764ba2);color:white;padding:20px;border:none}
        .alert-box{background:white;border-radius:12px;padding:20px;box-shadow:0 5px 15px rgba(0,0,0,0.1);transition:all 0.3s ease}
        .alert-box:hover{transform:translateY(-3px);box-shadow:0 10px 25px rgba(0,0,0,0.15)}
        .alert-icon{font-size:2.5rem;margin-bottom:10px}
        .alert-count{font-size:2.5rem;font-weight:700;margin-bottom:5px}
        .alert-label{font-size:1rem;font-weight:600;color:#343a40;margin-bottom:5px}
        .urgent-box{border-left:5px solid #dc3545}
        .warning-box{border-left:5px solid #ffc107}
        .watch-box{border-left:5px solid #28a745}
    </style>
</head>
<body>
<?php include 'navbar.php'; ?>
<div class="dashboard-container">
    <div class="header-card animate-card">
        <div class="row align-items-center">
            <div class="col-auto"><img src="logo.png" alt="Logo SBA" height="60" class="me-3"></div>
            <div class="col"><h2 class="fw-bold m-0 mb-2"><i class="fas fa-chart-line"></i> Dashboard SBA</h2><p class="mb-0 opacity-75">Laporan Penjualan Bulan <?= $currentMonthName ?></p></div>
            <div class="col-auto"><div class="date-time-card"><div class="text-center"><div class="fw-bold mb-1" style="font-size:0.9rem;"><i class="fas fa-calendar me-1"></i> <?= date('l, d F Y') ?></div><div class="fw-semibold" style="font-size:1.1rem;"><i class="fas fa-clock me-1"></i> <span id="live-clock"><?= date('H:i:s') ?></span></div></div></div></div>
        </div>
    </div>
    
    <div class="month-selector animate-card">
        <form method="GET" class="row align-items-center">
            <div class="col-md-6"><label class="form-label fw-bold"><i class="fas fa-calendar-alt"></i> Pilih Periode Laporan:</label><input type="month" class="form-control" name="month" value="<?= $selected_month ?>" onchange="this.form.submit()"></div>
            <div class="col-md-6"><div class="mt-4 mt-md-0"><div class="text-muted"><small>Periode: <?= date('d', strtotime($start_date)) ?> - <?= date('d', strtotime($end_date)) ?> <?= $currentMonthName ?></small></div><div class="text-primary fw-bold"><i class="fas fa-receipt"></i> <?= number_format($totalTransaksi) ?> transaksi</div></div></div>
        </form>
    </div>
    
    <div class="row mb-5">
        <div class="col-lg-3 col-md-6 mb-4"><div class="metric-card success animate-card h-100"><div class="card-body text-center p-4"><i class="fas fa-money-bill-wave metric-icon text-success"></i><div class="metric-value text-success">Rp <?= number_format($totalPenjualan, 0, ',', '.') ?></div><div class="metric-label">Total Penjualan</div><div class="mt-3"><small class="text-muted"><i class="fas fa-calendar-check text-success me-1"></i> <?= $currentMonthName ?></small></div></div></div></div>
        <div class="col-lg-3 col-md-6 mb-4"><div class="metric-card danger animate-card h-100"><div class="card-body text-center p-4"><i class="fas fa-shopping-cart metric-icon text-danger"></i><div class="metric-value text-danger">Rp <?= number_format($totalPembelian, 0, ',', '.') ?></div><div class="metric-label">Total Pembelian</div><div class="mt-3"><small class="text-muted"><i class="fas fa-arrow-down text-danger me-1"></i> Cost of Goods</small></div></div></div></div>
        <div class="col-lg-3 col-md-6 mb-4"><?php $cardClass = $profit >= 0 ? 'dark' : 'warning'; $textClass = $profit >= 0 ? 'dark' : 'warning'; ?><div class="metric-card <?= $cardClass ?> animate-card h-100"><div class="card-body text-center p-4"><i class="fas fa-chart-line metric-icon text-<?= $textClass ?>"></i><div class="metric-value text-<?= $textClass ?>">Rp <?= number_format($profit, 0, ',', '.') ?></div><div class="metric-label">Total Profit<?php $marginClass = $profitMargin >= 30 ? 'margin-good' : ($profitMargin >= 15 ? 'margin-average' : 'margin-poor'); ?><span class="margin-indicator <?= $marginClass ?>"><?= $profitMargin ?>% margin</span></div><div class="mt-3"><small class="text-muted"><i class="fas fa-percentage me-1"></i> Profit Margin: <?= $profitMargin ?>%</small></div></div></div></div>
        <div class="col-lg-3 col-md-6 mb-4"><div class="metric-card primary animate-card h-100"><div class="card-body text-center p-4"><i class="fas fa-bullseye metric-icon text-primary"></i><div class="metric-value text-primary"><?= $profitPercent ?>%</div><div class="metric-label">Progress Target</div><small class="text-muted d-block mb-3">Target: Rp <?= number_format($targetProfit, 0, ',', '.') ?></small><div class="progress-modern"><div class="progress-bar" style="width:<?= min(abs($profitPercent), 100) ?>%;--accent-color:#007bff;--accent-light:#66b3ff;"></div></div></div></div></div>
    </div>
<?php if ($totalFollowUp > 0): ?>
    <div class="row mb-5 dashboard-spacing">
        <div class="col-12">
            <div class="alert-follow-up-card animate-card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="fas fa-bell"></i> Customer Follow-up Alert</h5>
                        <span class="badge bg-light text-dark fs-6"><?= $totalFollowUp ?> customers</span>
                    </div>
                </div>
                <div class="card-body p-4">
                    <div class="row text-center mb-4">
                        <div class="col-md-4 mb-3">
                            <div class="alert-box urgent-box">
                                <div class="alert-icon">🔴</div>
                                <div class="alert-count"><?= count($followUpCustomers['urgent']) ?></div>
                                <div class="alert-label">URGENT</div>
                                <small class="text-muted d-block">45+ hari tidak order</small>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="alert-box warning-box">
                                <div class="alert-icon">🟡</div>
                                <div class="alert-count"><?= count($followUpCustomers['warning']) ?></div>
                                <div class="alert-label">WARNING</div>
                                <small class="text-muted d-block">30-44 hari tidak order</small>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="alert-box watch-box">
                                <div class="alert-icon">🟢</div>
                                <div class="alert-count"><?= count($followUpCustomers['watch']) ?></div>
                                <div class="alert-label">WATCH</div>
                                <small class="text-muted d-block">10-29 hari tidak order</small>
                            </div>
                        </div>
                    </div>

                    <div class="accordion" id="followUpAccordion">
                        <?php if (!empty($followUpCustomers['urgent'])): ?>
                        <div class="accordion-item border-danger mb-2">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#urgentList" style="background:rgba(220,53,69,0.1);color:#dc3545;font-weight:600">
                                    🔴 URGENT - 45+ hari (<?= count($followUpCustomers['urgent']) ?> customers)
                                </button>
                            </h2>
                            <div id="urgentList" class="accordion-collapse collapse" data-bs-parent="#followUpAccordion">
                                <div class="accordion-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-sm table-hover mb-0">
                                            <thead style="background:#dc3545;color:white">
                                                <tr>
                                                    <th>Customer</th>
                                                    <th>Kota</th>
                                                    <th>Last Order</th>
                                                    <th>Days Ago</th>
                                                    <th>Total Orders</th>
                                                    <th>Total Revenue</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($followUpCustomers['urgent'] as $cust): ?>
                                                <tr>
                                                    <td class="fw-bold"><?= htmlspecialchars($cust['nama']) ?></td>
                                                    <td><?= htmlspecialchars($cust['kota']) ?></td>
                                                    <td><?= date('d/m/Y', strtotime($cust['last_order_date'])) ?></td>
                                                    <td><span class="badge bg-danger"><?= $cust['days_since_last_order'] ?> hari</span></td>
                                                    <td><?= $cust['total_orders'] ?>x</td>
                                                    <td class="text-success fw-bold">Rp <?= number_format($cust['total_revenue'], 0, ',', '.') ?></td>
                                                    <td>
                                                        <?php if (!empty($cust['no_hp'])): ?>
                                                        <a href="https://wa.me/62<?= ltrim($cust['no_hp'], '0') ?>" target="_blank" class="btn btn-success btn-sm">
                                                            <i class="fab fa-whatsapp"></i> WA
                                                        </a>
                                                        <?php else: ?>
                                                        <span class="text-muted small">No HP</span>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>

                        <?php if (!empty($followUpCustomers['warning'])): ?>
                        <div class="accordion-item border-warning mb-2">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#warningList" style="background:rgba(255,193,7,0.1);color:#856404;font-weight:600">
                                    🟡 WARNING - 30-44 hari (<?= count($followUpCustomers['warning']) ?> customers)
                                </button>
                            </h2>
                            <div id="warningList" class="accordion-collapse collapse" data-bs-parent="#followUpAccordion">
                                <div class="accordion-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-sm table-hover mb-0">
                                            <thead style="background:#ffc107;color:#212529">
                                                <tr>
                                                    <th>Customer</th>
                                                    <th>Kota</th>
                                                    <th>Last Order</th>
                                                    <th>Days Ago</th>
                                                    <th>Total Orders</th>
                                                    <th>Total Revenue</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($followUpCustomers['warning'] as $cust): ?>
                                                <tr>
                                                    <td class="fw-bold"><?= htmlspecialchars($cust['nama']) ?></td>
                                                    <td><?= htmlspecialchars($cust['kota']) ?></td>
                                                    <td><?= date('d/m/Y', strtotime($cust['last_order_date'])) ?></td>
                                                    <td><span class="badge bg-warning text-dark"><?= $cust['days_since_last_order'] ?> hari</span></td>
                                                    <td><?= $cust['total_orders'] ?>x</td>
                                                    <td class="text-success fw-bold">Rp <?= number_format($cust['total_revenue'], 0, ',', '.') ?></td>
                                                    <td>
                                                        <?php if (!empty($cust['no_hp'])): ?>
                                                        <a href="https://wa.me/62<?= ltrim($cust['no_hp'], '0') ?>" target="_blank" class="btn btn-success btn-sm">
                                                            <i class="fab fa-whatsapp"></i> WA
                                                        </a>
                                                        <?php else: ?>
                                                        <span class="text-muted small">No HP</span>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>

                        <?php if (!empty($followUpCustomers['watch'])): ?>
                        <div class="accordion-item border-success mb-2">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#watchList" style="background:rgba(40,167,69,0.1);color:#155724;font-weight:600">
                                    🟢 WATCH - 10-29 hari (<?= count($followUpCustomers['watch']) ?> customers)
                                </button>
                            </h2>
                            <div id="watchList" class="accordion-collapse collapse" data-bs-parent="#followUpAccordion">
                                <div class="accordion-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-sm table-hover mb-0">
                                            <thead style="background:#28a745;color:white">
                                                <tr>
                                                    <th>Customer</th>
                                                    <th>Kota</th>
                                                    <th>Last Order</th>
                                                    <th>Days Ago</th>
                                                    <th>Total Orders</th>
                                                    <th>Total Revenue</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($followUpCustomers['watch'] as $cust): ?>
                                                <tr>
                                                    <td class="fw-bold"><?= htmlspecialchars($cust['nama']) ?></td>
                                                    <td><?= htmlspecialchars($cust['kota']) ?></td>
                                                    <td><?= date('d/m/Y', strtotime($cust['last_order_date'])) ?></td>
                                                    <td><span class="badge bg-success"><?= $cust['days_since_last_order'] ?> hari</span></td>
                                                    <td><?= $cust['total_orders'] ?>x</td>
                                                    <td class="text-success fw-bold">Rp <?= number_format($cust['total_revenue'], 0, ',', '.') ?></td>
                                                    <td>
                                                        <?php if (!empty($cust['no_hp'])): ?>
                                                        <a href="https://wa.me/62<?= ltrim($cust['no_hp'], '0') ?>" target="_blank" class="btn btn-success btn-sm">
                                                            <i class="fab fa-whatsapp"></i> WA
                                                        </a>
                                                        <?php else: ?>
                                                        <span class="text-muted small">No HP</span>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <?php if (!empty($itemsMasalah)): ?>
    <div class="row mb-5">
        <div class="col-12">
            <div class="stats-card animate-card">
                <div class="card-header bg-warning text-dark">
                    <h6 class="mb-0"><i class="fas fa-exclamation-triangle me-2"></i> Items Dengan Harga Beli > Harga Jual (<?= $currentMonthName ?>)
                        <span class="badge bg-danger ms-2"><?= count($itemsMasalah) ?> items</span>
                    </h6>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-sm mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Produk</th>
                                    <th>Qty</th>
                                    <th>Harga Jual</th>
                                    <th>Harga Beli</th>
                                    <th>Total Jual</th>
                                    <th>Total Beli</th>
                                    <th>Profit/Loss</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($itemsMasalah as $item): ?>
                                <tr>
                                    <td><?= htmlspecialchars($item['produk_nama'] ?? 'Unknown Product') ?></td>
                                    <td><?= number_format($item['qty']) ?></td>
                                    <td class="text-end">Rp <?= number_format($item['harga_jual'], 0, ',', '.') ?></td>
                                    <td class="text-end text-danger">Rp <?= number_format($item['harga_beli'], 0, ',', '.') ?></td>
                                    <td class="text-end">Rp <?= number_format($item['total_jual'], 0, ',', '.') ?></td>
                                    <td class="text-end">Rp <?= number_format($item['total_beli'], 0, ',', '.') ?></td>
                                    <td class="text-end text-danger fw-bold">Rp <?= number_format($item['profit_item'], 0, ',', '.') ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <div class="row mb-5 dashboard-spacing">
        <div class="col-md-6 mb-4">
            <div class="insights-card animate-card">
                <h6 class="fw-bold mb-4"><i class="fas fa-lightbulb me-2"></i> Business Insights - <?= $currentMonthName ?></h6>
                <div class="row text-center">
                    <div class="col-6">
                        <div class="border-end border-white border-opacity-25 pe-3">
                            <div class="h3 fw-bold mb-2"><?= $totalTransaksi ?></div>
                            <div class="small opacity-75">Total Transaksi</div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="ps-3">
                            <div class="h3 fw-bold mb-2"><?= $totalCustomer ?></div>
                            <div class="small opacity-75">Active Customers</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 mb-4">
            <div class="stats-card animate-card h-100">
                <div class="card-body p-4">
                    <h6 class="fw-bold text-dark mb-4"><i class="fas fa-star me-2"></i> Top Customers - <?= $currentMonthName ?></h6>
                    <?php if (!empty($topCustomers)): ?>
                        <?php foreach(array_slice($topCustomers, 0, 3) as $index => $customer): ?>
                        <div class="d-flex justify-content-between align-items-center mb-3 pb-3 <?= $index < 2 ? 'border-bottom' : '' ?>">
                            <div>
                                <div class="fw-semibold text-dark"><?= htmlspecialchars($customer['nama']) ?></div>
                                <small class="text-muted"><?= $customer['total_orders'] ?> orders</small>
                            </div>
                            <div class="text-end">
                                <div class="fw-bold text-success">Rp <?= number_format($customer['total_sales'], 0, ',', '.') ?></div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="text-center text-muted py-3">
                            <i class="fas fa-info-circle"></i>
                            <p class="mb-0">Belum ada transaksi di bulan ini</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <?php if ($totalCustomer > 0): ?>
    <div class="row mb-5 dashboard-spacing">
        <div class="col-12">
            <div class="stats-card animate-card">
                <div class="card-header bg-dark text-white rounded-top">
                    <h5 class="mb-0 py-2"><i class="fas fa-users me-2"></i> Customer Distribution (All Time)
                        <span class="badge bg-light text-dark ms-2"><?= $totalCustomer ?> Total</span>
                    </h5>
                </div>
                <div class="card-body p-4">
                    <?php if (!empty($perKotaGrouped)): ?>
                        <?php foreach ($perKotaGrouped as $prov => $kotas): ?>
                        <div class="province-card">
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <h6 class="fw-bold text-dark mb-0"><i class="fas fa-map-marker-alt text-primary me-2"></i> <?= $prov ?></h6>
                                <span class="badge-modern bg-primary text-white"><?= array_sum(array_column($kotas, 'total')) ?> customers</span>
                            </div>
                            <div class="row g-3">
                                <?php foreach ($kotas as $row): ?>
                                <div class="col-lg-3 col-md-4 col-sm-6">
                                    <div class="city-card">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <div class="fw-semibold text-dark"><?= $row['kota'] ?></div>
                                                <small class="text-muted">customers</small>
                                            </div>
                                            <span class="badge bg-dark rounded-pill"><?= $row['total'] ?></span>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <?php if ($totalCustomer > 0): ?>
    <div class="row">
        <div class="col-12">
            <div class="stats-card animate-card">
                <div class="card-header bg-dark text-white">
                    <h5 class="mb-0">
                        <a class="text-white text-decoration-none" data-bs-toggle="collapse" href="#customerList">
                            <i class="fas fa-list"></i> Daftar Customer Aktif <i class="fas fa-chevron-down float-end mt-1"></i>
                        </a>
                    </h5>
                </div>
                <div class="collapse" id="customerList">
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-modern table-hover mb-0">
                                <thead>
                                    <tr>
                                        <th width="50">#</th>
                                        <th>Nama Customer</th>
                                        <th>Kota</th>
                                        <th>Provinsi</th>
                                        <th>Jenis</th>
                                        <th>No. HP</th>
                                        <th>Catatan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($customerList)): ?>
                                        <?php $no = 1; foreach($customerList as $row): ?>
                                        <tr>
                                            <td><span class="badge bg-secondary rounded-pill"><?= $no++ ?></span></td>
                                            <td><div class="fw-bold text-dark"><?= htmlspecialchars($row['nama']) ?></div></td>
                                            <td><span class="text-primary fw-semibold"><?= htmlspecialchars($row['kota']) ?></span></td>
                                            <td><small class="text-muted"><?= htmlspecialchars($row['provinsi']) ?></small></td>
                                            <td><span class="badge-modern bg-info text-white"><?= htmlspecialchars($row['jenis'] ?? 'Regular') ?></span></td>
                                            <td>
                                                <?php if(!empty($row['no_hp'])): ?>
                                                <a href="https://wa.me/62<?= ltrim($row['no_hp'], '0') ?>" target="_blank" class="text-success text-decoration-none">
                                                    <i class="fab fa-whatsapp"></i> <?= htmlspecialchars($row['no_hp']) ?>
                                                </a>
                                                <?php else: ?>
                                                <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if(!empty($row['notes'])): ?>
                                                <small class="text-muted"><?= nl2br(htmlspecialchars(substr($row['notes'], 0, 100))) ?><?= strlen($row['notes']) > 100 ? '...' : '' ?></small>
                                                <?php else: ?>
                                                <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="7" class="text-center text-muted py-4">
                                                <i class="fas fa-users fa-3x mb-3"></i>
                                                <h5>Tidak ada data customer</h5>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php else: ?>
    <div class="row">
        <div class="col-12">
            <div class="stats-card animate-card">
                <div class="card-body p-4 text-center">
                    <i class="fas fa-users fa-3x text-muted mb-3"></i>
                    <h5>Tidak Ada Data Customer</h5>
                    <p class="text-muted">Tabel customer tidak ditemukan atau kosong</p>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
function updateClock() {
    const now = new Date();
    const hours = String(now.getHours()).padStart(2, '0');
    const minutes = String(now.getMinutes()).padStart(2, '0');
    const seconds = String(now.getSeconds()).padStart(2, '0');
    document.getElementById('live-clock').textContent = hours + ':' + minutes + ':' + seconds;
}
setInterval(updateClock, 1000);
updateClock();
</script>
</body>
</html>