<?php
// daily_work_list.php - Main listing page
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Include files
include 'config.php';
include 'session.php';

// Check database connection
if (!isset($conn) || !$conn) {
    die('Error: Database connection tidak tersedia!');
}

// Handle delete action
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $daily_work_id = (int)$_GET['id'];
    
    mysqli_begin_transaction($conn);
    
    try {
        // Delete results first
        mysqli_query($conn, "DELETE FROM daily_work_results WHERE daily_work_id = $daily_work_id");
        
        // Delete plans
        mysqli_query($conn, "DELETE FROM daily_work_plans WHERE daily_work_id = $daily_work_id");
        
        // Delete daily work
        $delete_work = mysqli_query($conn, "DELETE FROM daily_work WHERE id = $daily_work_id");
        
        if ($delete_work) {
            mysqli_commit($conn);
            $_SESSION['success_message'] = "Daily Work berhasil dihapus!";
        } else {
            throw new Exception("Gagal menghapus daily work");
        }
        
    } catch (Exception $e) {
        mysqli_rollback($conn);
        $_SESSION['error_message'] = "Error: " . $e->getMessage();
    }
    
    header('Location: daily_work_list.php');
    exit();
}

// Check if tables exist
$table_check = @mysqli_query($conn, "SHOW TABLES LIKE 'daily_work'");
if (!$table_check || mysqli_num_rows($table_check) == 0) {
    ?>
    <!DOCTYPE html>
    <html lang="id">
    <head>
        <meta charset="UTF-8">
        <title>Setup Required</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    </head>
    <body>
        <?php if (file_exists('navbar.php')) include 'navbar.php'; ?>
        <div class="container mt-4">
            <div class="alert alert-warning">
                <h4>Database Setup Required</h4>
                <p>Tabel daily work belum ada. Please run SQL setup first.</p>
                <a href="test_connection.php" class="btn btn-primary">Setup Database</a>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit();
}

// Get data
$daily_works = [];
$total_records = 0;

// Pagination
$limit = 15;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Search and filter
$search = isset($_GET['search']) ? mysqli_real_escape_string($conn, $_GET['search']) : '';
$month_filter = isset($_GET['month']) ? mysqli_real_escape_string($conn, $_GET['month']) : '';
$year_filter = isset($_GET['year']) ? mysqli_real_escape_string($conn, $_GET['year']) : date('Y');

// Build WHERE clause
$where_conditions = [];

if ($search) {
    $where_conditions[] = "(dw.created_by LIKE '%$search%' OR dwp.subject LIKE '%$search%' OR dwr.subject LIKE '%$search%')";
}

if ($month_filter) {
    $where_conditions[] = "MONTH(dw.tanggal) = '$month_filter'";
}

if ($year_filter) {
    $where_conditions[] = "YEAR(dw.tanggal) = '$year_filter'";
}

$where_clause = $where_conditions ? "WHERE " . implode(" AND ", $where_conditions) : "";

// Get total count
$count_sql = "
    SELECT COUNT(DISTINCT dw.id) as total
    FROM daily_work dw
    LEFT JOIN daily_work_plans dwp ON dw.id = dwp.daily_work_id
    LEFT JOIN daily_work_results dwr ON dw.id = dwr.daily_work_id
    $where_clause
";

$count_result = mysqli_query($conn, $count_sql);
if ($count_result) {
    $count_row = mysqli_fetch_assoc($count_result);
    $total_records = $count_row['total'];
}

$total_pages = ceil($total_records / $limit);

// Get daily works data
$sql = "
    SELECT 
        dw.id,
        dw.tanggal,
        dw.jam_masuk,
        dw.jam_pulang,
        dw.created_by,
        dw.created_at,
        COUNT(DISTINCT dwp.id) as total_plans,
        COUNT(DISTINCT dwr.id) as total_results,
        COUNT(DISTINCT CASE WHEN dwr.status = 'completed' THEN dwr.id END) as completed_results
    FROM daily_work dw
    LEFT JOIN daily_work_plans dwp ON dw.id = dwp.daily_work_id
    LEFT JOIN daily_work_results dwr ON dw.id = dwr.daily_work_id
    $where_clause
    GROUP BY dw.id, dw.tanggal, dw.jam_masuk, dw.jam_pulang, dw.created_by, dw.created_at
    ORDER BY dw.tanggal DESC, dw.created_at DESC
    LIMIT $limit OFFSET $offset
";

$result = mysqli_query($conn, $sql);
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $daily_works[] = $row;
    }
}

// Months array
$months = [
    1 => 'Januari', 2 => 'Februari', 3 => 'Maret', 4 => 'April',
    5 => 'Mei', 6 => 'Juni', 7 => 'Juli', 8 => 'Agustus',
    9 => 'September', 10 => 'Oktober', 11 => 'November', 12 => 'Desember'
];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daily Work Plan & Results</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/font-awesome.min.css">
    <style>
        .card-header {
            background: linear-gradient(135deg, #0066cc 0%, #0080ff 100%);
            color: white;
        }
        .table th {
            background-color: #f8f9fa;
            border-top: none;
            font-weight: 600;
            color: #495057;
        }
        .table-hover tbody tr:hover {
            background-color: rgba(0,102,204,.075);
        }
        .progress-circle {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 0.8em;
            font-weight: bold;
        }
        .filter-section {
            background-color: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>

<?php if (file_exists('navbar.php')) include 'navbar.php'; ?>

<div class="container mt-4">
    <div class="row">
        <div class="col-12">
            
            <!-- Messages -->
            <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success alert-dismissible fade show">
                    <?php echo $_SESSION['success_message']; unset($_SESSION['success_message']); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger alert-dismissible fade show">
                    <?php echo $_SESSION['error_message']; unset($_SESSION['error_message']); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            
            <div class="card shadow">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">
                        <i class="fa fa-tasks"></i> Daily Work Plan & Results
                    </h4>
                    <div>
                        <a href="daily_work_add.php" class="btn btn-light">
                            <i class="fa fa-plus"></i> Tambah Daily Work
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    
                    <!-- Summary Info -->
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <div class="card text-center border-success">
                                <div class="card-body">
                                    <h5 class="text-success"><?php echo $total_records; ?></h5>
                                    <small>Total Hari Kerja</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-center border-info">
                                <div class="card-body">
                                    <h5 class="text-info"><?php echo date('d M Y'); ?></h5>
                                    <small>Hari Ini</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-center border-warning">
                                <div class="card-body">
                                    <h5 class="text-warning"><?php echo date('M Y'); ?></h5>
                                    <small>Bulan Ini</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card text-center border-primary">
                                <div class="card-body">
                                    <h5 class="text-primary"><?php echo date('Y'); ?></h5>
                                    <small>Tahun Ini</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Filter Section -->
                    <div class="filter-section">
                        <form method="GET" class="row g-3">
                            <div class="col-md-4">
                                <input type="text" name="search" class="form-control" 
                                       placeholder="Cari berdasarkan nama atau aktivitas..." value="<?php echo htmlspecialchars($search); ?>">
                            </div>
                            <div class="col-md-3">
                                <select name="month" class="form-select">
                                    <option value="">Semua Bulan</option>
                                    <?php foreach ($months as $num => $name): ?>
                                        <option value="<?php echo $num; ?>" <?php echo $month_filter == $num ? 'selected' : ''; ?>>
                                            <?php echo $name; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select name="year" class="form-select">
                                    <?php for ($y = date('Y'); $y >= date('Y') - 3; $y--): ?>
                                        <option value="<?php echo $y; ?>" <?php echo $year_filter == $y ? 'selected' : ''; ?>>
                                            <?php echo $y; ?>
                                        </option>
                                    <?php endfor; ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fa fa-search"></i> Filter
                                </button>
                            </div>
                        </form>
                    </div>

                    <!-- Daily Work List -->
                    <?php if (empty($daily_works)): ?>
                        <div class="text-center py-5">
                            <i class="fa fa-clipboard-list fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">Tidak ada daily work ditemukan</h5>
                            <a href="daily_work_add.php" class="btn btn-success mt-2">
                                <i class="fa fa-plus"></i> Tambah Daily Work Pertama
                            </a>
                        </div>
                    <?php else: ?>
                        
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>Tanggal</th>
                                        <th>Jam Kerja</th>
                                        <th>Nama Pekerja</th>
                                        <th>Plan</th>
                                        <th>Results</th>
                                        <th>Progress</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($daily_works as $work): ?>
                                        <tr>
                                            <td>
                                                <div class="fw-bold">
                                                    <i class="fa fa-calendar text-primary"></i>
                                                    <?php echo date('d M Y', strtotime($work['tanggal'])); ?>
                                                </div>
                                                <small class="text-muted"><?php echo date('l', strtotime($work['tanggal'])); ?></small>
                                            </td>
                                            <td>
                                                <?php if ($work['jam_masuk'] || $work['jam_pulang']): ?>
                                                    <div>
                                                        <i class="fa fa-clock text-primary"></i>
                                                        <?php if ($work['jam_masuk']): ?>
                                                            <?php echo date('H:i', strtotime($work['jam_masuk'])); ?>
                                                        <?php endif; ?>
                                                        <?php if ($work['jam_pulang']): ?>
                                                            - <?php echo date('H:i', strtotime($work['jam_pulang'])); ?>
                                                        <?php endif; ?>
                                                    </div>
                                                    <?php 
                                                    if ($work['jam_masuk'] && $work['jam_pulang']) {
                                                        $start = new DateTime($work['jam_masuk']);
                                                        $end = new DateTime($work['jam_pulang']);
                                                        $diff = $start->diff($end);
                                                        echo '<small class="text-muted">(' . $diff->h . 'j ' . $diff->i . 'm)</small>';
                                                    }
                                                    ?>
                                                <?php else: ?>
                                                    <small class="text-muted">-</small>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <strong><?php echo htmlspecialchars($work['created_by'] ?: 'Unknown'); ?></strong>
                                            </td>
                                            <td class="text-center">
                                                <span class="badge bg-primary">
                                                    <?php echo (int)$work['total_plans']; ?> items
                                                </span>
                                            </td>
                                            <td class="text-center">
                                                <span class="badge bg-success">
                                                    <?php echo (int)$work['total_results']; ?> items
                                                </span>
                                            </td>
                                            <td>
                                                <?php 
                                                $progress = $work['total_plans'] > 0 ? ($work['completed_results'] / $work['total_plans']) * 100 : 0;
                                                $progress_class = $progress >= 80 ? 'bg-success' : ($progress >= 50 ? 'bg-warning' : 'bg-danger');
                                                ?>
                                                <div class="progress-circle <?php echo $progress_class; ?> text-white">
                                                    <?php echo round($progress); ?>%
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex gap-1 flex-wrap">
                                                    <button onclick="copyToWhatsApp(<?php echo (int)$work['id']; ?>)" 
                                                            class="btn btn-info btn-sm" title="Copy untuk WhatsApp">
                                                        <i class="fa fa-whatsapp"></i> WA
                                                    </button>
                                                    <a href="daily_work_print.php?id=<?php echo (int)$work['id']; ?>" 
                                                       class="btn btn-success btn-sm" target="_blank" title="Cetak laporan">
                                                        <i class="fa fa-print"></i> Cetak
                                                    </a>
                                                    <a href="daily_work_edit.php?id=<?php echo (int)$work['id']; ?>" 
                                                       class="btn btn-warning btn-sm" title="Edit data">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button onclick="deleteDailyWork(<?php echo (int)$work['id']; ?>, '<?php echo date('d M Y', strtotime($work['tanggal'])); ?>')" 
                                                            class="btn btn-danger btn-sm" title="Hapus data">
                                                        <i class="fa fa-trash"></i> Hapus
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <?php if ($total_pages > 1): ?>
                            <nav aria-label="Daily work pagination">
                                <ul class="pagination justify-content-center">
                                    <li class="page-item <?php echo $page <= 1 ? 'disabled' : ''; ?>">
                                        <a class="page-link" href="?page=<?php echo $page - 1; ?>&search=<?php echo urlencode($search); ?>&month=<?php echo urlencode($month_filter); ?>&year=<?php echo urlencode($year_filter); ?>">Previous</a>
                                    </li>
                                    
                                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                        <li class="page-item <?php echo $i == $page ? 'active' : ''; ?>">
                                            <a class="page-link" href="?page=<?php echo $i; ?>&search=<?php echo urlencode($search); ?>&month=<?php echo urlencode($month_filter); ?>&year=<?php echo urlencode($year_filter); ?>"><?php echo $i; ?></a>
                                        </li>
                                    <?php endfor; ?>
                                    
                                    <li class="page-item <?php echo $page >= $total_pages ? 'disabled' : ''; ?>">
                                        <a class="page-link" href="?page=<?php echo $page + 1; ?>&search=<?php echo urlencode($search); ?>&month=<?php echo urlencode($month_filter); ?>&year=<?php echo urlencode($year_filter); ?>">Next</a>
                                    </li>
                                </ul>
                            </nav>
                        <?php endif; ?>
                        
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Konfirmasi Hapus Daily Work</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin menghapus daily work <strong id="workDate"></strong>?</p>
                <div class="alert alert-warning">
                    <i class="fa fa-exclamation-triangle"></i> 
                    <strong>Peringatan:</strong> Semua data terkait akan dihapus permanen.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <a href="#" id="deleteConfirmBtn" class="btn btn-danger">
                    <i class="fa fa-trash"></i> Ya, Hapus
                </a>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
function deleteDailyWork(id, workDate) {
    document.getElementById('workDate').textContent = workDate;
    document.getElementById('deleteConfirmBtn').href = 'daily_work_list.php?action=delete&id=' + id;
    
    var deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
    deleteModal.show();
}

async function copyToWhatsApp(id) {
    try {
        // Show loading
        const button = event.target.closest('button');
        const originalHtml = button.innerHTML;
        button.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Loading...';
        button.disabled = true;
        
        // Fetch data dari server
        const response = await fetch(`daily_work_copy.php?id=${id}`);
        if (!response.ok) {
            throw new Error('Network response was not ok');
        }
        
        const data = await response.json();
        
        if (data.success) {
            // Copy ke clipboard
            await navigator.clipboard.writeText(data.whatsapp_text);
            
            // Show success
            button.innerHTML = '<i class="fa fa-check"></i> Copied!';
            button.classList.remove('btn-info');
            button.classList.add('btn-success');
            
            // Reset button after 2 seconds
            setTimeout(() => {
                button.innerHTML = originalHtml;
                button.classList.remove('btn-success');
                button.classList.add('btn-info');
                button.disabled = false;
            }, 2000);
            
            // Show toast notification
            showToast('✅ Daily Work berhasil dicopy! Silakan paste di WhatsApp.', 'success');
            
        } else {
            throw new Error(data.message || 'Failed to generate WhatsApp text');
        }
        
    } catch (error) {
        console.error('Error:', error);
        
        // Reset button
        const button = event.target.closest('button');
        button.innerHTML = '<i class="fa fa-whatsapp"></i> WA';
        button.disabled = false;
        
        // Show error
        showToast('❌ Gagal copy data: ' + error.message, 'error');
    }
}

function showToast(message, type = 'info') {
    // Create toast element
    const toast = document.createElement('div');
    toast.className = `alert alert-${type === 'success' ? 'success' : 'danger'} alert-dismissible fade show position-fixed`;
    toast.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    toast.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(toast);
    
    // Auto remove after 5 seconds
    setTimeout(() => {
        if (toast.parentNode) {
            toast.parentNode.removeChild(toast);
        }
    }, 5000);
}
</script>

</body>
</html>