<?php
include 'config.php';
include 'session.php';
include 'navbar.php';
$token = 'zGt9owFVAfGg8eMRpCKd';

function kirimWA($nama, $wa, $jenis, $token, $pesan_custom = '') {
    $pesan = $pesan_custom !== ''
        ? str_replace(['{nama}', '{jenis}'], [$nama, $jenis], $pesan_custom)
        : "Hai $nama,\n\nKami ingin menginformasikan penawaran terbaru untuk kebutuhan *$jenis* Anda.\n\nSilakan hubungi kami untuk info lebih lanjut.\n\nTerima kasih. 🙏";

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://api.fonnte.com/send",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => [
            'target' => $wa,
            'message' => $pesan
        ],
        CURLOPT_HTTPHEADER => [
            "Authorization: $token"
        ],
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    return $response;
}

$kota = $_GET['kota'] ?? '';
$jenis = $_GET['jenis'] ?? '';
$send = $_GET['send'] ?? '';
$pesan_custom = $_GET['pesan'] ?? '';

$where = [];
if ($kota != '') $where[] = "kota = '" . mysqli_real_escape_string($conn, $kota) . "'";
if ($jenis != '') $where[] = "jenis = '" . mysqli_real_escape_string($conn, $jenis) . "'";
$where_sql = count($where) > 0 ? 'WHERE ' . implode(' AND ', $where) : '';

$query = "SELECT * FROM customer $where_sql ORDER BY nama";
$result = mysqli_query($conn, $query);
if (!$result) die("Query error: " . mysqli_error($conn));

$response_log = "";
if ($send == '1') {
    while ($row = mysqli_fetch_assoc($result)) {
    $nama = $row['nama'];
    $wa = explode(',', $row['no_hp'])[0];
    $jenis_pesan = $row['jenis'];

    // Kirim ke customer
    $response1 = kirimWA($nama, $wa, $jenis_pesan, $token, $pesan_custom);
    $response_log .= "$nama ($wa): $response1\n";

    
}

    // Kirim juga ke nomor admin
    $admin_wa = '081234000772'; // Ganti dengan nomor yang kamu inginkan
    $response2 = kirimWA($nama, $admin_wa, $jenis_pesan, $token, $pesan_custom);
    $response_log .= "Admin ($admin_wa) copy of $nama: $response2\n";

    echo "<div class='container mt-4'><div class='alert alert-info'><pre>$response_log</pre></div></div>";
    mysqli_data_seek($result, 0);
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Broadcast WhatsApp</title>
    <!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container my-5">
    <h2 class="mb-4">Broadcast WhatsApp</h2>
    <form method="GET" action="" class="mb-4">
        <div class="row g-3">
            <div class="col-md-4">
                <label for="kota" class="form-label">Kota</label>
                <select name="kota" id="kota" class="form-select select2">

                    <option value="">- Semua -</option>
                    <?php
                    $kotas = mysqli_query($conn, "SELECT DISTINCT kota FROM customer WHERE kota IS NOT NULL AND kota != '' ORDER BY kota");
                    while ($k = mysqli_fetch_assoc($kotas)) {
                        $val = $k['kota'];
                        echo "<option value=\"$val\" " . ($val == $kota ? 'selected' : '') . ">$val</option>";
                    }
                    ?>
                </select>
            </div>

            <div class="col-md-4">
                <label for="jenis" class="form-label">Jenis</label>
                <select name="jenis" id="jenis" class="form-select">
                    <option value="">- Semua -</option>
                    <option value="Sembako" <?= $jenis == 'Sembako' ? 'selected' : '' ?>>Sembako</option>
                    <option value="Bangunan" <?= $jenis == 'Bangunan' ? 'selected' : '' ?>>Bangunan</option>
                    <option value="Sembako dan Bangunan" <?= $jenis == 'Sembako dan Bangunan' ? 'selected' : '' ?>>Sembako dan Bangunan</option>
                </select>
            </div>

            <div class="col-md-12">
                <label for="pesan" class="form-label">Pesan</label>
                <textarea name="pesan" id="pesan" class="form-control" rows="4"><?= htmlspecialchars($pesan_custom) ?></textarea>
                <div class="form-text">Gunakan <code>{nama}</code> dan <code>{jenis}</code> untuk isi otomatis.</div>
            </div>

            <div class="col-md-12 mt-3">
                <button type="submit" class="btn btn-primary">Tampilkan</button>
                <?php if (mysqli_num_rows($result) > 0): ?>
                    <button type="submit" name="send" value="1" class="btn btn-danger" onclick="return confirm('Yakin kirim ke semua?')">Kirim Semua</button>
                <?php endif; ?>
            </div>
        </div>
    </form>

    <?php if (mysqli_num_rows($result) > 0): ?>
        <div class="table-responsive">
            <table class="table table-bordered table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Nama</th>
                        <th>Kota</th>
                        <th>WA</th>
                        <th>Jenis</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = mysqli_fetch_assoc($result)): ?>
                    <tr>
                        <td><?= htmlspecialchars($row['nama']) ?></td>
                        <td><?= htmlspecialchars($row['kota']) ?></td>
                        <td><?= htmlspecialchars($row['no_hp']) ?></td>
                        <td><?= htmlspecialchars($row['jenis']) ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="alert alert-warning">Tidak ada data ditemukan untuk filter tersebut.</div>
    <?php endif; ?>
</div>
<!-- jQuery dan Select2 JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('.select2').select2({
            placeholder: "Pilih atau ketik nama kota...",
            allowClear: true,
            width: '100%'
        });
    });
</script>

</body>
</html>
